import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::DirectoryService::MicrosoftAD`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 */
export interface CfnMicrosoftADProps {
    /**
     * `AWS::DirectoryService::MicrosoftAD.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name
     */
    readonly name: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Password`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password
     */
    readonly password: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.VpcSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings
     */
    readonly vpcSettings: CfnMicrosoftAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.CreateAlias`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias
     */
    readonly createAlias?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Edition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition
     */
    readonly edition?: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.EnableSso`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso
     */
    readonly enableSso?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.ShortName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname
     */
    readonly shortName?: string;
}
/**
 * A CloudFormation `AWS::DirectoryService::MicrosoftAD`
 *
 * @cloudformationResource AWS::DirectoryService::MicrosoftAD
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 */
export declare class CfnMicrosoftAD extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::MicrosoftAD";
    /**
     * @cloudformationAttribute Alias
     */
    readonly attrAlias: string;
    /**
     * @cloudformationAttribute DnsIpAddresses
     */
    readonly attrDnsIpAddresses: string[];
    /**
     * `AWS::DirectoryService::MicrosoftAD.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name
     */
    name: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Password`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password
     */
    password: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.VpcSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings
     */
    vpcSettings: CfnMicrosoftAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.CreateAlias`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias
     */
    createAlias: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Edition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition
     */
    edition: string | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.EnableSso`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso
     */
    enableSso: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.ShortName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname
     */
    shortName: string | undefined;
    /**
     * Create a new `AWS::DirectoryService::MicrosoftAD`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMicrosoftADProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnMicrosoftAD {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html
     */
    interface VpcSettingsProperty {
        /**
         * `CfnMicrosoftAD.VpcSettingsProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html#cfn-directoryservice-microsoftad-vpcsettings-subnetids
         */
        readonly subnetIds: string[];
        /**
         * `CfnMicrosoftAD.VpcSettingsProperty.VpcId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html#cfn-directoryservice-microsoftad-vpcsettings-vpcid
         */
        readonly vpcId: string;
    }
}
/**
 * Properties for defining a `AWS::DirectoryService::SimpleAD`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 */
export interface CfnSimpleADProps {
    /**
     * `AWS::DirectoryService::SimpleAD.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-name
     */
    readonly name: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Password`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-password
     */
    readonly password: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Size`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-size
     */
    readonly size: string;
    /**
     * `AWS::DirectoryService::SimpleAD.VpcSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-vpcsettings
     */
    readonly vpcSettings: CfnSimpleAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.CreateAlias`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-createalias
     */
    readonly createAlias?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-description
     */
    readonly description?: string;
    /**
     * `AWS::DirectoryService::SimpleAD.EnableSso`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-enablesso
     */
    readonly enableSso?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.ShortName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-shortname
     */
    readonly shortName?: string;
}
/**
 * A CloudFormation `AWS::DirectoryService::SimpleAD`
 *
 * @cloudformationResource AWS::DirectoryService::SimpleAD
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 */
export declare class CfnSimpleAD extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::SimpleAD";
    /**
     * @cloudformationAttribute Alias
     */
    readonly attrAlias: string;
    /**
     * @cloudformationAttribute DnsIpAddresses
     */
    readonly attrDnsIpAddresses: string[];
    /**
     * `AWS::DirectoryService::SimpleAD.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-name
     */
    name: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Password`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-password
     */
    password: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Size`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-size
     */
    size: string;
    /**
     * `AWS::DirectoryService::SimpleAD.VpcSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-vpcsettings
     */
    vpcSettings: CfnSimpleAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.CreateAlias`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-createalias
     */
    createAlias: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-description
     */
    description: string | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.EnableSso`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-enablesso
     */
    enableSso: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.ShortName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-shortname
     */
    shortName: string | undefined;
    /**
     * Create a new `AWS::DirectoryService::SimpleAD`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimpleADProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSimpleAD {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html
     */
    interface VpcSettingsProperty {
        /**
         * `CfnSimpleAD.VpcSettingsProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html#cfn-directoryservice-simplead-vpcsettings-subnetids
         */
        readonly subnetIds: string[];
        /**
         * `CfnSimpleAD.VpcSettingsProperty.VpcId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html#cfn-directoryservice-simplead-vpcsettings-vpcid
         */
        readonly vpcId: string;
    }
}
