# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetProjectsResult:
    """
    A collection of values returned by getProjects.
    """
    def __init__(__self__, archived=None, group_id=None, id=None, include_subgroups=None, max_queryable_pages=None, membership=None, min_access_level=None, order_by=None, owned=None, page=None, per_page=None, projects=None, search=None, simple=None, sort=None, starred=None, statistics=None, visibility=None, with_custom_attributes=None, with_issues_enabled=None, with_merge_requests_enabled=None, with_programming_language=None, with_shared=None):
        if archived and not isinstance(archived, bool):
            raise TypeError("Expected argument 'archived' to be a bool")
        __self__.archived = archived
        if group_id and not isinstance(group_id, float):
            raise TypeError("Expected argument 'group_id' to be a float")
        __self__.group_id = group_id
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if include_subgroups and not isinstance(include_subgroups, bool):
            raise TypeError("Expected argument 'include_subgroups' to be a bool")
        __self__.include_subgroups = include_subgroups
        if max_queryable_pages and not isinstance(max_queryable_pages, float):
            raise TypeError("Expected argument 'max_queryable_pages' to be a float")
        __self__.max_queryable_pages = max_queryable_pages
        if membership and not isinstance(membership, bool):
            raise TypeError("Expected argument 'membership' to be a bool")
        __self__.membership = membership
        if min_access_level and not isinstance(min_access_level, float):
            raise TypeError("Expected argument 'min_access_level' to be a float")
        __self__.min_access_level = min_access_level
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        __self__.order_by = order_by
        if owned and not isinstance(owned, bool):
            raise TypeError("Expected argument 'owned' to be a bool")
        __self__.owned = owned
        if page and not isinstance(page, float):
            raise TypeError("Expected argument 'page' to be a float")
        __self__.page = page
        if per_page and not isinstance(per_page, float):
            raise TypeError("Expected argument 'per_page' to be a float")
        __self__.per_page = per_page
        if projects and not isinstance(projects, list):
            raise TypeError("Expected argument 'projects' to be a list")
        __self__.projects = projects
        """
        A list containing the projects matching the supplied arguments
        """
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        __self__.search = search
        if simple and not isinstance(simple, bool):
            raise TypeError("Expected argument 'simple' to be a bool")
        __self__.simple = simple
        if sort and not isinstance(sort, str):
            raise TypeError("Expected argument 'sort' to be a str")
        __self__.sort = sort
        if starred and not isinstance(starred, bool):
            raise TypeError("Expected argument 'starred' to be a bool")
        __self__.starred = starred
        if statistics and not isinstance(statistics, bool):
            raise TypeError("Expected argument 'statistics' to be a bool")
        __self__.statistics = statistics
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        __self__.visibility = visibility
        """
        The visibility of the project.
        """
        if with_custom_attributes and not isinstance(with_custom_attributes, bool):
            raise TypeError("Expected argument 'with_custom_attributes' to be a bool")
        __self__.with_custom_attributes = with_custom_attributes
        if with_issues_enabled and not isinstance(with_issues_enabled, bool):
            raise TypeError("Expected argument 'with_issues_enabled' to be a bool")
        __self__.with_issues_enabled = with_issues_enabled
        if with_merge_requests_enabled and not isinstance(with_merge_requests_enabled, bool):
            raise TypeError("Expected argument 'with_merge_requests_enabled' to be a bool")
        __self__.with_merge_requests_enabled = with_merge_requests_enabled
        if with_programming_language and not isinstance(with_programming_language, str):
            raise TypeError("Expected argument 'with_programming_language' to be a str")
        __self__.with_programming_language = with_programming_language
        if with_shared and not isinstance(with_shared, bool):
            raise TypeError("Expected argument 'with_shared' to be a bool")
        __self__.with_shared = with_shared
class AwaitableGetProjectsResult(GetProjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectsResult(
            archived=self.archived,
            group_id=self.group_id,
            id=self.id,
            include_subgroups=self.include_subgroups,
            max_queryable_pages=self.max_queryable_pages,
            membership=self.membership,
            min_access_level=self.min_access_level,
            order_by=self.order_by,
            owned=self.owned,
            page=self.page,
            per_page=self.per_page,
            projects=self.projects,
            search=self.search,
            simple=self.simple,
            sort=self.sort,
            starred=self.starred,
            statistics=self.statistics,
            visibility=self.visibility,
            with_custom_attributes=self.with_custom_attributes,
            with_issues_enabled=self.with_issues_enabled,
            with_merge_requests_enabled=self.with_merge_requests_enabled,
            with_programming_language=self.with_programming_language,
            with_shared=self.with_shared)

def get_projects(archived=None,group_id=None,include_subgroups=None,max_queryable_pages=None,membership=None,min_access_level=None,order_by=None,owned=None,page=None,per_page=None,search=None,simple=None,sort=None,starred=None,statistics=None,visibility=None,with_custom_attributes=None,with_issues_enabled=None,with_merge_requests_enabled=None,with_programming_language=None,with_shared=None,opts=None):
    """
    Provides details about a list of projects in the Gitlab provider. Listing all projects and group projects with [project filtering](https://docs.gitlab.com/ee/api/projects.html#list-user-projects) or [group project filtering](https://docs.gitlab.com/ee/api/groups.html#list-a-groups-projects) is supported.

    > NOTE: This data source supports all available filters exposed by the `xanzy/go-gitlab` package, which might not expose all available filters exposed by the Gitlab APIs.   

    ## Example Usage

    ### List projects within a group tree

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    mygroup = gitlab.get_group(full_path="mygroup")
    group_projects = gitlab.get_projects(group_id=mygroup.id,
        order_by="name",
        include_subgroups=True,
        with_shared=False)
    ```

    ### List projects using the search syntax

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    projects = gitlab.get_projects(search="postgresql",
        visibility="private")
    ```



    :param bool archived: Limit by archived status.
    :param float group_id: The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
    :param bool include_subgroups: Include projects in subgroups of this group. Default is `false`. Needs `group_id`.
    :param float max_queryable_pages: Prevents overloading your Gitlab instance in case of a misconfiguration. Default is `10`.
    :param bool membership: Limit by projects that the current user is a member of.
    :param float min_access_level: Limit to projects where current user has at least this access level, refer to the [official documentation](https://docs.gitlab.com/ee/api/members.html) for values. Cannot be used with `group_id`.
    :param str order_by: Return projects ordered by `id`, `name`, `path`, `created_at`, `updated_at`, or `last_activity_at` fields. Default is `created_at`.
    :param bool owned: Limit by projects owned by the current user.
    :param str search: Return list of authorized projects matching the search criteria.
    :param bool simple: Return only the ID, URL, name, and path of each project.
    :param str sort: Return projects sorted in `asc` or `desc` order. Default is `desc`.
    :param bool starred: Limit by projects starred by the current user.
    :param bool statistics: Include project statistics. Cannot be used with `group_id`.
    :param str visibility: Limit by visibility `public`, `internal`, or `private`.
    :param bool with_custom_attributes: Include custom attributes in response _(admins only)_.
    :param bool with_issues_enabled: Limit by projects with issues feature enabled. Default is `false`.
    :param bool with_merge_requests_enabled: Limit by projects with merge requests feature enabled. Default is `false`.
    :param str with_programming_language: Limit by projects which use the given programming language. Cannot be used with `group_id`.
    :param bool with_shared: Include projects shared to this group. Default is `true`. Needs `group_id`.
    """
    __args__ = dict()


    __args__['archived'] = archived
    __args__['groupId'] = group_id
    __args__['includeSubgroups'] = include_subgroups
    __args__['maxQueryablePages'] = max_queryable_pages
    __args__['membership'] = membership
    __args__['minAccessLevel'] = min_access_level
    __args__['orderBy'] = order_by
    __args__['owned'] = owned
    __args__['page'] = page
    __args__['perPage'] = per_page
    __args__['search'] = search
    __args__['simple'] = simple
    __args__['sort'] = sort
    __args__['starred'] = starred
    __args__['statistics'] = statistics
    __args__['visibility'] = visibility
    __args__['withCustomAttributes'] = with_custom_attributes
    __args__['withIssuesEnabled'] = with_issues_enabled
    __args__['withMergeRequestsEnabled'] = with_merge_requests_enabled
    __args__['withProgrammingLanguage'] = with_programming_language
    __args__['withShared'] = with_shared
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjects:getProjects', __args__, opts=opts).value

    return AwaitableGetProjectsResult(
        archived=__ret__.get('archived'),
        group_id=__ret__.get('groupId'),
        id=__ret__.get('id'),
        include_subgroups=__ret__.get('includeSubgroups'),
        max_queryable_pages=__ret__.get('maxQueryablePages'),
        membership=__ret__.get('membership'),
        min_access_level=__ret__.get('minAccessLevel'),
        order_by=__ret__.get('orderBy'),
        owned=__ret__.get('owned'),
        page=__ret__.get('page'),
        per_page=__ret__.get('perPage'),
        projects=__ret__.get('projects'),
        search=__ret__.get('search'),
        simple=__ret__.get('simple'),
        sort=__ret__.get('sort'),
        starred=__ret__.get('starred'),
        statistics=__ret__.get('statistics'),
        visibility=__ret__.get('visibility'),
        with_custom_attributes=__ret__.get('withCustomAttributes'),
        with_issues_enabled=__ret__.get('withIssuesEnabled'),
        with_merge_requests_enabled=__ret__.get('withMergeRequestsEnabled'),
        with_programming_language=__ret__.get('withProgrammingLanguage'),
        with_shared=__ret__.get('withShared'))
