# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GroupLdapLink(pulumi.CustomResource):
    access_level: pulumi.Output[str]
    """
    Acceptable values are: guest, reporter, developer, maintainer, owner.
    """
    cn: pulumi.Output[str]
    """
    The CN of the LDAP group to link with.
    """
    force: pulumi.Output[bool]
    group_id: pulumi.Output[str]
    """
    The id of the GitLab group.
    """
    ldap_provider: pulumi.Output[str]
    """
    The name of the LDAP provider as stored in the GitLab database.
    """
    def __init__(__self__, resource_name, opts=None, access_level=None, cn=None, force=None, group_id=None, ldap_provider=None, __props__=None, __name__=None, __opts__=None):
        """
        This resource allows you to add an LDAP link to an existing GitLab group.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        test = gitlab.GroupLdapLink("test",
            access_level="developer",
            cn="testuser",
            group_id="12345",
            ldap_provider="ldapmain")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_level: Acceptable values are: guest, reporter, developer, maintainer, owner.
        :param pulumi.Input[str] cn: The CN of the LDAP group to link with.
        :param pulumi.Input[str] group_id: The id of the GitLab group.
        :param pulumi.Input[str] ldap_provider: The name of the LDAP provider as stored in the GitLab database.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if access_level is None:
                raise TypeError("Missing required property 'access_level'")
            __props__['access_level'] = access_level
            if cn is None:
                raise TypeError("Missing required property 'cn'")
            __props__['cn'] = cn
            __props__['force'] = force
            if group_id is None:
                raise TypeError("Missing required property 'group_id'")
            __props__['group_id'] = group_id
            if ldap_provider is None:
                raise TypeError("Missing required property 'ldap_provider'")
            __props__['ldap_provider'] = ldap_provider
        super(GroupLdapLink, __self__).__init__(
            'gitlab:index/groupLdapLink:GroupLdapLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, access_level=None, cn=None, force=None, group_id=None, ldap_provider=None):
        """
        Get an existing GroupLdapLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_level: Acceptable values are: guest, reporter, developer, maintainer, owner.
        :param pulumi.Input[str] cn: The CN of the LDAP group to link with.
        :param pulumi.Input[str] group_id: The id of the GitLab group.
        :param pulumi.Input[str] ldap_provider: The name of the LDAP provider as stored in the GitLab database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_level"] = access_level
        __props__["cn"] = cn
        __props__["force"] = force
        __props__["group_id"] = group_id
        __props__["ldap_provider"] = ldap_provider
        return GroupLdapLink(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

