"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JoinedJson = exports.Match = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assertions_1 = require("aws-cdk-lib/assertions");
class Match extends assertions_1.Match {
    static joinedJson(pattern) {
        return new JoinedJson(pattern);
    }
}
exports.Match = Match;
_a = JSII_RTTI_SYMBOL_1;
Match[_a] = { fqn: "cdk-extensions.asserts.Match", version: "0.0.38" };
class JoinedJson extends assertions_1.Matcher {
    constructor(pattern) {
        super();
        this.name = 'joinedManifest',
            this.pattern = pattern;
    }
    static parseInput(join) {
        const joinArgs = join['Fn::Join'];
        const sep = joinArgs[0];
        const input = joinArgs[1];
        const output = [];
        input.forEach((x) => {
            if (typeof x === 'string') {
                output.push(x);
            }
            else {
                output.push(aws_cdk_lib_1.Token.asNumber(x).toString());
            }
        });
        const joined = output.join(sep);
        const fullObj = JSON.parse(joined);
        return JoinedJson.recursiveResolve(fullObj);
    }
    static recursiveResolve(obj) {
        if (typeof obj === 'string') {
            if (aws_cdk_lib_1.Token.isUnresolved(obj)) {
                const parts = aws_cdk_lib_1.Tokenization.reverseString(obj);
                const unresolvedFragments = JoinedJson.coerceArray(parts.join({
                    join: (a, b) => {
                        const standardA = JoinedJson.coerceArray(a);
                        return standardA.concat(JoinedJson.coerceArray(b));
                    },
                }));
                const intrinsicFragments = unresolvedFragments.map((x) => {
                    return aws_cdk_lib_1.Token.isUnresolved(x) ? aws_cdk_lib_1.Tokenization.reverseCompleteString(x) : x;
                });
                const objectFragments = intrinsicFragments.map((x) => {
                    if (typeof x === 'string') {
                        return x;
                    }
                    else if (x instanceof aws_cdk_lib_1.Intrinsic) {
                        return x.resolve({
                            documentPath: [],
                            preparing: false,
                            registerPostProcessor: (_postProcessor) => { },
                            resolve: (_x, _options) => { return undefined; },
                            scope: new aws_cdk_lib_1.Stack(undefined, 'resolver'),
                        });
                    }
                    else {
                        throw new Error('Got unexpected type while resolving objects.');
                    }
                });
                return (objectFragments.length === 1 && typeof objectFragments[0] !== 'string') ? objectFragments[0] : {
                    'Fn::Join': ['', objectFragments],
                };
            }
            else {
                return obj;
            }
        }
        else if (Array.isArray(obj)) {
            return obj.map((x) => {
                return JoinedJson.recursiveResolve(x);
            });
        }
        else if (typeof obj === 'object') {
            return Object.keys(obj).reduce((prev, cur) => {
                prev[cur] = JoinedJson.recursiveResolve(obj[cur]);
                return prev;
            }, {});
        }
        else {
            return obj;
        }
    }
    static coerceArray(obj) {
        return Array.isArray(obj) ? obj : [obj];
    }
    test(actual) {
        const result = new assertions_1.MatchResult(actual);
        let parsed = actual;
        if (typeof parsed !== 'string') {
            parsed = JoinedJson.parseInput(actual);
        }
        const matcher = assertions_1.Matcher.isMatcher(this.pattern) ? this.pattern : Match.exact(this.pattern);
        const innerResult = matcher.test(parsed);
        result.compose(`(${this.name})`, innerResult);
        return result;
    }
}
exports.JoinedJson = JoinedJson;
_b = JSII_RTTI_SYMBOL_1;
JoinedJson[_b] = { fqn: "cdk-extensions.asserts.JoinedJson", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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