"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataSize = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class DataSize {
    /**
       * Creates a new instance of the DataSize class.
       *
       * @param bytes The number of bytes being represented.
       */
    constructor(bytes) {
        this._bytes = bytes;
    }
    /**
       * Create a `DataSize` representing an amount of bytes.
       *
       * @param bytes The number of bytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of bytes.
       */
    static bytes(bytes) {
        return new DataSize(bytes);
    }
    /**
       * Create a `DataSize` representing an amount of gibibytes.
       *
       * @param gibibytes The number of gibibytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of gibibytes.
       */
    static gibibytes(gibibytes) {
        return new DataSize(gibibytes * 1024 * 1024 * 1024);
    }
    /**
       * Create a `DataSize` representing an amount of gigabytes.
       *
       * @param gigabytes The number of gigabytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of gigabytes.
       */
    static gigabytes(gigabytes) {
        return new DataSize(gigabytes * 1000 * 1000 * 1000);
    }
    /**
       * Create a `DataSize` representing an amount of kibibytes.
       *
       * @param kibibytes The number of kibibytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of kibibytes.
       */
    static kibibytes(kibibytes) {
        return new DataSize(kibibytes * 1024);
    }
    /**
       * Create a `DataSize` representing an amount of kilobytes.
       *
       * @param kilobytes The number of kilobytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of kilobytes.
       */
    static kilobytes(kilobytes) {
        return new DataSize(kilobytes * 1000);
    }
    /**
       * Create a `DataSize` representing an amount of mebibytes.
       *
       * @param mebibytes The number of mebibytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of mebibytes.
       */
    static mebibytes(mebibytes) {
        return new DataSize(mebibytes * 1024 * 1024);
    }
    /**
       * Create a `DataSize` representing an amount of megabytes.
       *
       * @param megabytes The number of megabytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of megabytes.
       */
    static megabytes(megabytes) {
        return new DataSize(megabytes * 1000 * 1000);
    }
    /**
       * Create a `DataSize` representing an amount of pebibytes.
       *
       * @param pebibytes The number of pebibytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of pebibytes.
       */
    static pebibytes(pebibytes) {
        return new DataSize(pebibytes * 1024 * 1024 * 1024 * 1024 * 1024);
    }
    /**
       * Create a `DataSize` representing an amount of petabytes.
       *
       * @param petabytes The number of petabytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of petabytes.
       */
    static petabytes(petabytes) {
        return new DataSize(petabytes * 1000 * 1000 * 1000 * 1000 * 1000);
    }
    /**
       * Create a `DataSize` representing an amount of tebibytes.
       *
       * @param tebibytes The number of tebibytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of tebibytes.
       */
    static tebibytes(tebibytes) {
        return new DataSize(tebibytes * 1024 * 1024 * 1024 * 1024);
    }
    /**
       * Create a `DataSize` representing an amount of terabytes.
       *
       * @param terabytes The number of terabytes this `DataSize` will represent.
       * @returns A `DataSize` representing the specified number of terabytes.
       */
    static terabytes(terabytes) {
        return new DataSize(terabytes * 1000 * 1000 * 1000 * 1000);
    }
    /**
       * Convert the DataSize object to the byte representation.
       *
       * @returns The number of bytes for the data size.
       */
    toBytes() {
        return this._bytes;
    }
    /**
       * Convert the DataSize object to its gibibyte representation.
       *
       * If the data size doesn't fit evently into gibibytes it will be rounded
       * up to the closest gibibyte which will be required to hold all the data.
       *
       * @returns The number of gibibytes for the data size.
       */
    toGibibytes() {
        return Math.ceil(this._bytes / 1024 / 1024 / 1024);
    }
    /**
       * Convert the DataSize object to its gigabyte representation.
       *
       * If the data size doesn't fit evently into gigabytes it will be rounded
       * up to the closest gigabyte which will be required to hold all the data.
       *
       * @returns The number of gigabytes for the data size.
       */
    toGigabytes() {
        return Math.ceil(this._bytes / 1000 / 1000 / 1000);
    }
    /**
       * Convert the DataSize object to its kibibyte representation.
       *
       * If the data size doesn't fit evently into kibibytes it will be rounded
       * up to the closest kibibyte which will be required to hold all the data.
       *
       * @returns The number of kibibytes for the data size.
       */
    toKibibytes() {
        return Math.ceil(this._bytes / 1024);
    }
    /**
       * Convert the DataSize object to its kilobyte representation.
       *
       * If the data size doesn't fit evently into kilobytes it will be rounded
       * up to the closest kilobyte which will be required to hold all the data.
       *
       * @returns The number of kilobytes for the data size.
       */
    toKilobytes() {
        return Math.ceil(this._bytes / 1000);
    }
    /**
       * Convert the DataSize object to its mebibyte representation.
       *
       * If the data size doesn't fit evently into mebibytes it will be rounded
       * up to the closest mebibyte which will be required to hold all the data.
       *
       * @returns The number of mebibytes for the data size.
       */
    toMebibytes() {
        return Math.ceil(this._bytes / 1024 / 1024);
    }
    /**
       * Convert the DataSize object to its megabyte representation.
       *
       * If the data size doesn't fit evently into megabytes it will be rounded
       * up to the closest megabyte which will be required to hold all the data.
       *
       * @returns The number of megabytes for the data size.
       */
    toMegabytes() {
        return Math.ceil(this._bytes / 1000 / 1000);
    }
    /**
       * Convert the DataSize object to its pebibyte representation.
       *
       * If the data size doesn't fit evently into pebibytes it will be rounded
       * up to the closest pebibyte which will be required to hold all the data.
       *
       * @returns The number of pebibytes for the data size.
       */
    toPebibytes() {
        return Math.ceil(this._bytes / 1024 / 1024 / 1024 / 1024 / 1024);
    }
    /**
       * Convert the DataSize object to its petabyte representation.
       *
       * If the data size doesn't fit evently into petabytes it will be rounded
       * up to the closest petabyte which will be required to hold all the data.
       *
       * @returns The number of petabytes for the data size.
       */
    toPetabytes() {
        return Math.ceil(this._bytes / 1000 / 1000 / 1000 / 1000 / 1000);
    }
    /**
       * Convert the DataSize object to its tebibyte representation.
       *
       * If the data size doesn't fit evently into tebibytes it will be rounded
       * up to the closest tebibyte which will be required to hold all the data.
       *
       * @returns The number of tebibytes for the data size.
       */
    toTebibytes() {
        return Math.ceil(this._bytes / 1024 / 1024 / 1024 / 1024);
    }
    /**
       * Convert the DataSize object to its terabyte representation.
       *
       * If the data size doesn't fit evently into terabytes it will be rounded
       * up to the closest terabyte which will be required to hold all the data.
       *
       * @returns The number of terabytes for the data size.
       */
    toTerabytes() {
        return Math.ceil(this._bytes / 1000 / 1000 / 1000 / 1000);
    }
}
exports.DataSize = DataSize;
_a = JSII_RTTI_SYMBOL_1;
DataSize[_a] = { fqn: "cdk-extensions.core.DataSize", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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