import { Resource } from 'aws-cdk-lib';
import { FargateCluster, FargateClusterProps } from 'aws-cdk-lib/aws-eks';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { IParameter } from 'aws-cdk-lib/aws-ssm';
import { Construct } from 'constructs';
import { FargateLogger, FargateLoggerOptions, Route53Dns, Route53DnsOptions } from '../k8s-aws';
import { AdotCollector } from '../k8s-aws/adot-collector';
import { ExternalSecret } from '../k8s-aws/external-secret';
import { ExternalSecretsOperator, NamespacedExternalSecretOptions } from '../k8s-aws/external-secrets-operator';
/**
 * Configuration options for enabling CloudWatch monitoring on the cluster.
 */
export interface ContainerInsightsOptions {
    /**
     * Flag that controls whether CloudWatch Monitoring should be enabled or not.
     *
     * @default true
     */
    readonly enabled?: boolean;
    /**
     * The Kubernetes namespace where resources related to the the configuration
     * of Container Insights will be created.
     *
     * @default {@link AdotCollector.DEFAULT_NAMESPACE}
     */
    readonly namespace?: string;
}
/**
 * Configuration options for enabling persistent logging for Fargate containers
 * on the cluster.
 */
export interface ClusterFargateLoggingOptions extends FargateLoggerOptions {
    /**
       * Controls whether logging will be set up for pods using the default
       * Fargate provide on the EKS cluster.
       *
       * @default true
       */
    readonly enabled?: boolean;
}
export interface ClusterRoute53DnsOptions extends Route53DnsOptions {
    readonly enabled?: boolean;
}
export interface ExternalSecretsOptions {
    readonly enabled?: boolean;
    readonly createNamespace?: boolean;
    readonly name?: string;
    readonly namespace?: string;
}
export interface AwsIntegratedFargateClusterProps extends FargateClusterProps {
    readonly containerInsightsOptions?: ContainerInsightsOptions;
    readonly externalDnsOptions?: ClusterRoute53DnsOptions;
    readonly externalSecretsOptions?: ExternalSecretsOptions;
    readonly loggingOptions?: ClusterFargateLoggingOptions;
}
export declare class AwsIntegratedFargateCluster extends Resource {
    readonly adotCollector?: AdotCollector;
    readonly externalSecrets?: ExternalSecretsOperator;
    readonly fargateLogger?: FargateLogger;
    readonly route53Dns?: Route53Dns;
    readonly resource: FargateCluster;
    constructor(scope: Construct, id: string, props: AwsIntegratedFargateClusterProps);
    registerSecretsManagerSecret(id: string, secret: ISecret, options?: NamespacedExternalSecretOptions): ExternalSecret;
    registerSsmParameterSecret(id: string, parameter: IParameter, options?: NamespacedExternalSecretOptions): ExternalSecret;
}
