"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegratedFargateCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
const k8s_aws_1 = require("../k8s-aws");
const adot_collector_1 = require("../k8s-aws/adot-collector");
const external_secrets_operator_1 = require("../k8s-aws/external-secrets-operator");
class AwsIntegratedFargateCluster extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.resource = new aws_eks_1.FargateCluster(this, 'cluster', {
            ...props,
        });
        let lastResource = this.resource;
        if (props.loggingOptions?.enabled ?? true) {
            this.fargateLogger = new k8s_aws_1.FargateLogger(this, 'fargate-logger', {
                cluster: this.resource,
                fargateProfiles: [
                    this.resource.defaultProfile,
                ],
            });
            this.fargateLogger.node.addDependency(lastResource);
            lastResource = this.fargateLogger;
        }
        if (props.containerInsightsOptions?.enabled ?? true) {
            this.adotCollector = new adot_collector_1.AdotCollector(this, 'adot-collector', {
                cluster: this.resource,
            });
            this.adotCollector.node.addDependency(lastResource);
            const fargateProfile = this.resource.addFargateProfile('adot-collector', {
                selectors: [
                    {
                        namespace: this.adotCollector.namespace,
                    },
                ],
            });
            this.fargateLogger?.addFargateProfile(fargateProfile);
            lastResource = this.adotCollector;
        }
        if (props.externalDnsOptions?.enabled ?? true) {
            this.route53Dns = new k8s_aws_1.Route53Dns(this, 'route-53-dns', {
                ...(props.externalDnsOptions ?? {}),
                cluster: this.resource,
            });
            this.route53Dns.node.addDependency(lastResource);
            lastResource = this.route53Dns;
        }
        if (props.externalSecretsOptions?.enabled ?? true) {
            this.externalSecrets = new external_secrets_operator_1.ExternalSecretsOperator(this, 'external-secrets', {
                ...(props.externalSecretsOptions ?? {}),
                cluster: this.resource,
            });
            this.externalSecrets.node.addDependency(lastResource);
            const fargateProfile = this.resource.addFargateProfile('external-secrets', {
                selectors: [
                    {
                        namespace: this.externalSecrets.namespace,
                    },
                ],
            });
            this.fargateLogger?.addFargateProfile(fargateProfile);
            lastResource = this.externalSecrets;
        }
    }
    registerSecretsManagerSecret(id, secret, options = {}) {
        if (this.externalSecrets) {
            return this.externalSecrets.registerSecretsManagerSecret(id, secret, options);
        }
        else {
            throw new Error('Cannot register secret as external secret functionality was explicitly disabled.');
        }
    }
    registerSsmParameterSecret(id, parameter, options = {}) {
        if (this.externalSecrets) {
            return this.externalSecrets.registerSsmParameterSecret(id, parameter, options);
        }
        else {
            throw new Error('Cannot register secret as external secret functionality was explicitly disabled.');
        }
    }
}
exports.AwsIntegratedFargateCluster = AwsIntegratedFargateCluster;
_a = JSII_RTTI_SYMBOL_1;
AwsIntegratedFargateCluster[_a] = { fqn: "cdk-extensions.eks_patterns.AwsIntegratedFargateCluster", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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