"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedisEngine = exports.CacheEngine = exports.CacheEngineFamily = exports.CacheEngineName = void 0;
var CacheEngineName;
(function (CacheEngineName) {
    CacheEngineName["MEMCACHED"] = "memcached";
    CacheEngineName["REDIS"] = "redis";
})(CacheEngineName = exports.CacheEngineName || (exports.CacheEngineName = {}));
class CacheEngineFamily {
    constructor(name) {
        this.name = name;
    }
    static of(name) {
        return new CacheEngineFamily(name);
    }
    toString() {
        return this.name;
    }
}
exports.CacheEngineFamily = CacheEngineFamily;
CacheEngineFamily.MEMCACHED_1_4 = CacheEngineFamily.of('memcached1.4');
CacheEngineFamily.MEMCACHED_1_5 = CacheEngineFamily.of('memcached1.5');
CacheEngineFamily.MEMCACHED_1_6 = CacheEngineFamily.of('memcached1.6');
CacheEngineFamily.REDIS_2_6 = CacheEngineFamily.of('redis2.6');
CacheEngineFamily.REDIS_2_8 = CacheEngineFamily.of('redis2.8');
CacheEngineFamily.REDIS_3_2 = CacheEngineFamily.of('redis3.2');
CacheEngineFamily.REDIS_4_0 = CacheEngineFamily.of('redis4.0');
CacheEngineFamily.REDIS_5_0 = CacheEngineFamily.of('redis5.0');
CacheEngineFamily.REDIS_6_X = CacheEngineFamily.of('redis6.x');
class CacheEngine {
    constructor(name, version, options) {
        this.engineName = name;
        this.engineVersion = version;
        this.engineFamily = options?.engineFamily ?? CacheEngineFamily.of(`${name}${version.split('.')[0]}.x`);
    }
}
exports.CacheEngine = CacheEngine;
class RedisEngine extends CacheEngine {
    constructor(version, options) {
        super(CacheEngineName.REDIS, version);
        this.defaultPort = 6379;
        this.transitEncryptionSupported = options?.transitEncryptionSupported ?? true;
    }
    static of(version, options) {
        return new RedisEngine(version, options);
    }
}
exports.RedisEngine = RedisEngine;
RedisEngine.V_2_6_13 = RedisEngine.of('2.6.13', {
    engineFamily: CacheEngineFamily.REDIS_2_6,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_6 = RedisEngine.of('2.8.6', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_19 = RedisEngine.of('2.8.19', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_21 = RedisEngine.of('2.8.21', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_22 = RedisEngine.of('2.8.22', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_23 = RedisEngine.of('2.8.23', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_24 = RedisEngine.of('2.8.24', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_3_2_4 = RedisEngine.of('3.2.4', {
    engineFamily: CacheEngineFamily.REDIS_3_2,
    transitEncryptionSupported: false,
});
RedisEngine.V_3_2_6 = RedisEngine.of('3.2.6', {
    engineFamily: CacheEngineFamily.REDIS_3_2,
    transitEncryptionSupported: true,
});
RedisEngine.V_3_2_10 = RedisEngine.of('3.2.10', {
    engineFamily: CacheEngineFamily.REDIS_3_2,
    transitEncryptionSupported: true,
});
RedisEngine.V_4_0_10 = RedisEngine.of('4.0.10', {
    engineFamily: CacheEngineFamily.REDIS_4_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_0 = RedisEngine.of('5.0.0', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_3 = RedisEngine.of('5.0.3', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_4 = RedisEngine.of('5.0.4', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_5 = RedisEngine.of('5.0.5', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_6 = RedisEngine.of('5.0.6', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_6_0 = RedisEngine.of('6.0', {
    engineFamily: CacheEngineFamily.REDIS_6_X,
    transitEncryptionSupported: true,
});
RedisEngine.V_6_2 = RedisEngine.of('6.2', {
    engineFamily: CacheEngineFamily.REDIS_6_X,
    transitEncryptionSupported: true,
});
//# sourceMappingURL=data:application/json;base64,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