"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Shard = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
class Shard {
    constructor(options) {
        // Internal properties
        this._replicaAvailabilityZones = [];
        this._slots = [];
        this.nodeGroupId = options.nodeGroupId;
        this.primaryAvailabilityZone = options.primaryAvailabilityZone;
        this.replicaCount = options.replicaCount;
        options.replicaAvailabilityZones?.forEach((x) => {
            this.addReplicaAvailabilityZone(x);
        });
        options.slots?.forEach((x) => {
            this.addSlot(x);
        });
    }
    // Standard accessors
    get collapsible() {
        if (this.nodeGroupId !== undefined) {
            return false;
        }
        else if (this.primaryAvailabilityZone !== undefined) {
            return false;
        }
        else if (this.replicaAvailabilityZones !== undefined) {
            return false;
        }
        else if (this.slots !== undefined) {
            return false;
        }
        else {
            return true;
        }
    }
    get replicaAvailabilityZones() {
        return this._replicaAvailabilityZones.length ? this._replicaAvailabilityZones : undefined;
    }
    get slots() {
        return this._slots.length ? this._slots : undefined;
    }
    addReplicaAvailabilityZone(zone) {
        this._replicaAvailabilityZones.push(zone);
        return this;
    }
    addSlot(slot) {
        this._slots.push(slot);
        return this;
    }
    bind(_scope) {
        return {
            nodeGroupId: this.nodeGroupId,
            primaryAvailabilityZone: this.primaryAvailabilityZone,
            replicaAvailabilityZones: aws_cdk_lib_1.Lazy.list({
                produce: () => {
                    return this.replicaAvailabilityZones;
                },
            }, {
                omitEmpty: true,
            }),
            replicaCount: this.replicaCount,
            slots: aws_cdk_lib_1.Lazy.uncachedString({
                produce: () => {
                    if (!this.slots) {
                        return undefined;
                    }
                    return [
                        Array.from(Array(this._slots.length).keys()).join(','),
                        this.slots.join(','),
                    ].join(',');
                },
            }),
        };
    }
}
exports.Shard = Shard;
//# sourceMappingURL=data:application/json;base64,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