"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class CloudfrontLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the CloudfrontAccessLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'date',
                    type: 'date',
                }),
                new glue_1.BasicColumn({
                    name: 'time',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'location',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'response_bytes',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'request_ip',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'method',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'distribution',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'uri',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'status_code',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'referrer',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'user_agent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'query_string',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'cookie',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'final_result_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'host_header',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_protocol',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_bytes',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'time_taken',
                    type: 'float',
                }),
                new glue_1.BasicColumn({
                    name: 'x_forwarded_for',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'ssl_protocol',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'ssl_cipher',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'initial_result_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'http_version',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'fle_status',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'fle_encrypted_fields',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'client_port',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'time_to_first_byte',
                    type: 'float',
                }),
                new glue_1.BasicColumn({
                    name: 'detailed_result_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'content_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'content_length',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'content_range_start',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'content_range_end',
                    type: 'bigint',
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.LAZY_SIMPLE,
            },
            database: props.database,
            description: 'Table used for querying CloudFront access logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'skip.header.line.count': '2',
            },
            serdeParameters: {
                'field.delim': '\t',
                'serialization.format': '\t',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.distributionStatisticsNamedQuery = new athena_1.NamedQuery(this, 'distribution-statistics-named-query', {
                database: this.database,
                description: 'Gets statistics for CloudFront distributions for the last day.',
                name: this.friendlyQueryNames ? 'cloudfront-distribution-statistics' : undefined,
                queryString: [
                    'SELECT distribution,',
                    '    COUNT(*) as requests,',
                    '    SUM(request_bytes) AS bytes_in,',
                    '    SUM(response_bytes) AS bytes_out,',
                    "    (COUNT_IF(initial_result_type = 'Hit') / CAST(COUNT(*) AS double)) * 100 AS hit_rate,",
                    "    (COUNT_IF(final_result_type = 'Error') / CAST(COUNT(*) AS double)) * 100 AS error_rate,",
                    '    COUNT(DISTINCT uri) AS distinct_objects',
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    'GROUP BY distribution',
                    'ORDER BY distribution ASC LIMIT 100;',
                ].join('\n'),
            });
            this.requestErrorsNamedQuery = new athena_1.NamedQuery(this, 'request-errors-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent requests that resulted in an error from CloudFront.',
                name: this.friendlyQueryNames ? 'cloudfront-request-errors' : undefined,
                queryString: [
                    'SELECT FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) AT TIME ZONE \'UTC\' AS "time",',
                    '    request_ip,',
                    '    status_code,',
                    '    initial_result_type,',
                    '    final_result_type,',
                    '    detailed_result_type AS reason,',
                    '    method,',
                    "    CONCAT(request_protocol, '://', host_header, uri) AS url",
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    '    AND (',
                    "        initial_result_type IN ('Error', 'LimitExceeded', 'CapacityExceeded')",
                    "        OR final_result_type IN ('Error', 'LimitExceeded', 'CapacityExceeded')",
                    '    )',
                    'ORDER BY "date", time DESC LIMIT 100;',
                ].join('\n'),
            });
            this.topIpsNamedQuery = new athena_1.NamedQuery(this, 'top-ips-named-query', {
                database: this.database,
                description: 'Gets the 100 most active IP addresses by request count.',
                name: this.friendlyQueryNames ? 'cloudfront-top-ips' : undefined,
                queryString: [
                    'SELECT request_ip,',
                    '    COUNT(*) as requests,',
                    "    COUNT_IF(final_result_type = 'Error') AS errors,",
                    "    COUNT_IF(initial_result_type = 'Hit') AS hits,",
                    "    COUNT_IF(initial_result_type = 'Miss') AS misses,",
                    "    COUNT_IF(initial_result_type = 'RefreshHit') AS refreshes,",
                    "    (COUNT_IF(initial_result_type = 'Hit') / CAST(COUNT(*) AS double)) * 100 AS hit_rate,",
                    '    SUM(request_bytes) AS bytes_in,',
                    '    SUM(response_bytes) AS bytes_out,',
                    '    ARBITRARY(user_agent) as user_agent',
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    'GROUP BY request_ip',
                    'ORDER BY requests DESC LIMIT 100;',
                ].join('\n'),
            });
            this.topObjectsNamedQuery = new athena_1.NamedQuery(this, 'top-objects-named-query', {
                database: this.database,
                description: 'Gets the 100 most requested CloudFront objects.',
                name: this.friendlyQueryNames ? 'cloudfront-top-objects' : undefined,
                queryString: [
                    "SELECT CONCAT(request_protocol, '://', distribution, uri) AS object,",
                    '    COUNT(*) as requests,',
                    "    COUNT_IF(final_result_type = 'Error') AS errors,",
                    "    COUNT_IF(initial_result_type = 'Hit') AS hits,",
                    "    COUNT_IF(initial_result_type = 'Miss') AS misses,",
                    "    COUNT_IF(initial_result_type = 'RefreshHit') AS refreshes,",
                    "    (COUNT_IF(initial_result_type = 'Hit') / CAST(COUNT(*) AS double)) * 100 AS hit_rate,",
                    '    SUM(request_bytes) AS request_bytes,',
                    '    SUM(response_bytes) AS response_bytes,',
                    '    COUNT(DISTINCT request_ip) AS distinct_ips',
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    "GROUP BY CONCAT(request_protocol, '://', distribution, uri)",
                    'ORDER BY requests DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.CloudfrontLogsTable = CloudfrontLogsTable;
_a = JSII_RTTI_SYMBOL_1;
CloudfrontLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.CloudfrontLogsTable", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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