import { ResourceProps } from 'aws-cdk-lib';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { NamedQuery } from '../athena';
import { Database, Table } from '../glue';
/**
 * Configuration for FlowLogsTable
 */
export interface CloudtrailTableProps extends ResourceProps {
    /**
     * A bucket where logs will be stored
     *
     * @see [AWS S3 iBucket](https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_s3.IBucket.html)
     */
    readonly bucket: IBucket;
    /**
      * Boolean indicating whether to create default Athena queries for the Cloudtrail Logs
      *
      * @see [`CfnNamedQueries`](https://docs.aws.amazon.com/cdk/api/v1/python/aws_cdk.aws_athena/CfnNamedQuery.html)
      */
    readonly createQueries?: boolean;
    /**
     * A cdk-extensions/glue {@link aws-glue!Database } object that the table should be created in.
     *
     * @see [AWS::Glue::Database](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html)
     */
    readonly database: Database;
    /**
      * Boolean for adding "friendly names" for the created Athena queries.
      */
    readonly friendlyQueryNames?: boolean;
    /**
      * Name for Cloudtrail Logs Table
      */
    readonly name?: string;
    /**
      * Set a custom prefix for the S3 Bucket
      */
    readonly s3Prefix?: string;
}
export declare class CloudtrailTable extends Table {
    /**
      * Boolean indicating whether to create default Athena queries for the Cloudtrail Logs
      *
      * @see [`CfnNamedQueries`](https://docs.aws.amazon.com/cdk/api/v1/python/aws_cdk.aws_athena/CfnNamedQuery.html)
      */
    readonly createQueries: boolean;
    /**
      * Boolean for adding "friendly names" for the created Athena queries.
      */
    readonly friendlyQueryNames: boolean;
    readonly unauthorizedNamedQuery?: NamedQuery;
    readonly userLoginsNamedQuery?: NamedQuery;
    /**
       * Creates a new instance of the FlowLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props: CloudtrailTableProps);
}
