"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudtrailTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const region_info_1 = require("aws-cdk-lib/region-info");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class CloudtrailTable extends glue_1.Table {
    /**
       * Creates a new instance of the FlowLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        const projectionYear = new Date().getFullYear() - 1;
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'eventVersion',
                    type: 'string',
                }),
                new glue_1.StructColumn({
                    name: 'userIdentity',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'type',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'principalId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'arn',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'accountId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'invokedBy',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'accessKeyId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'userName',
                            type: 'string',
                        }),
                        new glue_1.StructColumn({
                            name: 'sessionContext',
                            data: [
                                new glue_1.StructColumn({
                                    name: 'attributes',
                                    data: [
                                        new glue_1.BasicColumn({
                                            name: 'mfaAuthenticated',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'creationDate',
                                            type: 'string',
                                        }),
                                    ],
                                }),
                                new glue_1.StructColumn({
                                    name: 'sessionIssuer',
                                    data: [
                                        new glue_1.BasicColumn({
                                            name: 'type',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'principalId',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'arn',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'accountId',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'userName',
                                            type: 'string',
                                        }),
                                    ],
                                }),
                            ],
                        }),
                    ],
                }),
                new glue_1.BasicColumn({
                    name: 'eventTime',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'eventSource',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'eventName',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'awsRegion',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'sourceIpAddress',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'userAgent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'errorCode',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'errorMessage',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'requestParameters',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'responseElements',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'additionalEventData',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'requestId',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'eventId',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'readOnly',
                    type: 'string',
                }),
                new glue_1.ArrayColumn({
                    name: 'resources',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'arn',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'accountId',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'type',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.BasicColumn({
                    name: 'eventType',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'apiVersion',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'recipientAccountId',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'serviceEventDetails',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'sharedEventID',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'vpcendpointid',
                    type: 'string',
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.CLOUDTRAIL,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.CLOUDTRAIL,
            },
            database: props.database,
            description: 'Table used for querying AWS API history.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'projection.day.format': 'yyyy/MM/dd',
                'projection.day.interval': '1',
                'projection.day.range': `${projectionYear}/01/01,NOW`,
                'projection.day.type': 'date',
                'projection.day.interval.unit': 'DAYS',
                'projection.logname.type': 'enum',
                'projection.logname.values': 'CloudTrail',
                'projection.regionname.type': 'enum',
                'projection.regionname.values': region_info_1.RegionInfo.regions.map((x) => {
                    return x.name;
                }).join(','),
                'projection.source.type': 'enum',
                'projection.source.values': aws_cdk_lib_1.Lazy.string({
                    produce: () => {
                        if (aws_cdk_lib_1.Token.isUnresolved(this.stack.account)) {
                            aws_cdk_lib_1.Annotations.of(this).addWarning([
                                `CloudTrail table stack for ${this.node.path} is environment agnostic.`,
                                'Cross account partition projection cannot be configured on environment',
                                'agnostic stacks. To enable partition projection please specify an account',
                                `for the ${this.stack.node.path} stack.`,
                            ].join(' '));
                            return this.stack.account;
                        }
                        else {
                            return [...new Set(this.node.root.node.findAll().reduce((prev, cur) => {
                                    if ((cur instanceof aws_cdk_lib_1.Stage || cur instanceof aws_cdk_lib_1.Stack) && cur.account && !aws_cdk_lib_1.Token.isUnresolved(cur.account)) {
                                        prev.push(cur.account);
                                    }
                                    return prev;
                                }, []))].join(',');
                        }
                    },
                }),
                'projection.enabled': 'true',
                'storage.location.template': `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/\${source}/\${logname}/\${regionname}/\${day}`,
            },
            partitionKeys: [
                new glue_1.BasicColumn({
                    name: 'source',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'logname',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'regionname',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'day',
                    type: 'string',
                }),
            ],
            serdeParameters: {
                'serialization.format': '1',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.unauthorizedNamedQuery = new athena_1.NamedQuery(this, 'unauthorized-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent unauthorized AWS API calls.',
                name: this.friendlyQueryNames ? 'cloudtrail-unauthorized-errors' : undefined,
                queryString: [
                    "SELECT FROM_ISO8601_TIMESTAMP(eventtime) AT TIME ZONE 'UTC' AS time,",
                    "    CONCAT(SPLIT(eventsource, '.')[1], ':', eventname) AS event,",
                    '    useridentity.arn as entity,',
                    '    useridentity.accountid as srcaccount,',
                    '    recipientaccountid as dstaccount,',
                    '    awsregion,',
                    '    errormessage,',
                    '    requestparameters as params',
                    `FROM ${this.tableName}`,
                    "WHERE (errorcode LIKE 'AccessDenied%' OR errorcode LIKE '%UnauthorizedOperation')",
                    "    AND day >= DATE_FORMAT(NOW() - PARSE_DURATION('1d'), '%Y/%m/%d')",
                    "    AND FROM_ISO8601_TIMESTAMP(eventtime) >= NOW() - PARSE_DURATION('1d')",
                    'ORDER BY eventtime DESC LIMIT 100;',
                ].join('\n'),
            });
            this.userLoginsNamedQuery = new athena_1.NamedQuery(this, 'user-logins-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent AWS user logins.',
                name: this.friendlyQueryNames ? 'cloudtrail-user-logins' : undefined,
                queryString: [
                    "SELECT FROM_ISO8601_TIMESTAMP(eventtime) AT TIME ZONE 'UTC' AS time,",
                    "    CONCAT(SPLIT(eventsource, '.')[1], ':', eventname) AS event,",
                    '    useridentity.username as username,',
                    '    useridentity.accountid as account,',
                    '    awsregion',
                    `FROM ${this.tableName}`,
                    "WHERE eventname = 'ConsoleLogin'",
                    "    AND day >= DATE_FORMAT(NOW() - PARSE_DURATION('30d'), '%Y/%m/%d')",
                    "    AND FROM_ISO8601_TIMESTAMP(eventtime) >= NOW() - PARSE_DURATION('30d')",
                    'ORDER BY eventtime DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.CloudtrailTable = CloudtrailTable;
_a = JSII_RTTI_SYMBOL_1;
CloudtrailTable[_a] = { fqn: "cdk-extensions.glue_tables.CloudtrailTable", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWR0cmFpbC10YWJsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9nbHVlLXRhYmxlcy9jbG91ZHRyYWlsLXRhYmxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQW9GO0FBRXBGLHlEQUFxRDtBQUVyRCxzQ0FBdUM7QUFDdkMsa0NBQThJO0FBdUM5SSxNQUFhLGVBQWdCLFNBQVEsWUFBSztJQWtCeEM7Ozs7Ozs7U0FPSztJQUNMLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMkI7UUFDbkUsTUFBTSxjQUFjLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFFcEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixPQUFPLEVBQUU7Z0JBQ1AsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxjQUFjO29CQUNwQixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksbUJBQVksQ0FBQztvQkFDZixJQUFJLEVBQUUsY0FBYztvQkFDcEIsSUFBSSxFQUFFO3dCQUNKLElBQUksa0JBQVcsQ0FBQzs0QkFDZCxJQUFJLEVBQUUsTUFBTTs0QkFDWixJQUFJLEVBQUUsUUFBUTt5QkFDZixDQUFDO3dCQUNGLElBQUksa0JBQVcsQ0FBQzs0QkFDZCxJQUFJLEVBQUUsYUFBYTs0QkFDbkIsSUFBSSxFQUFFLFFBQVE7eUJBQ2YsQ0FBQzt3QkFDRixJQUFJLGtCQUFXLENBQUM7NEJBQ2QsSUFBSSxFQUFFLEtBQUs7NEJBQ1gsSUFBSSxFQUFFLFFBQVE7eUJBQ2YsQ0FBQzt3QkFDRixJQUFJLGtCQUFXLENBQUM7NEJBQ2QsSUFBSSxFQUFFLFdBQVc7NEJBQ2pCLElBQUksRUFBRSxRQUFRO3lCQUNmLENBQUM7d0JBQ0YsSUFBSSxrQkFBVyxDQUFDOzRCQUNkLElBQUksRUFBRSxXQUFXOzRCQUNqQixJQUFJLEVBQUUsUUFBUTt5QkFDZixDQUFDO3dCQUNGLElBQUksa0JBQVcsQ0FBQzs0QkFDZCxJQUFJLEVBQUUsYUFBYTs0QkFDbkIsSUFBSSxFQUFFLFFBQVE7eUJBQ2YsQ0FBQzt3QkFDRixJQUFJLGtCQUFXLENBQUM7NEJBQ2QsSUFBSSxFQUFFLFVBQVU7NEJBQ2hCLElBQUksRUFBRSxRQUFRO3lCQUNmLENBQUM7d0JBQ0YsSUFBSSxtQkFBWSxDQUFDOzRCQUNmLElBQUksRUFBRSxnQkFBZ0I7NEJBQ3RCLElBQUksRUFBRTtnQ0FDSixJQUFJLG1CQUFZLENBQUM7b0NBQ2YsSUFBSSxFQUFFLFlBQVk7b0NBQ2xCLElBQUksRUFBRTt3Q0FDSixJQUFJLGtCQUFXLENBQUM7NENBQ2QsSUFBSSxFQUFFLGtCQUFrQjs0Q0FDeEIsSUFBSSxFQUFFLFFBQVE7eUNBQ2YsQ0FBQzt3Q0FDRixJQUFJLGtCQUFXLENBQUM7NENBQ2QsSUFBSSxFQUFFLGNBQWM7NENBQ3BCLElBQUksRUFBRSxRQUFRO3lDQUNmLENBQUM7cUNBQ0g7aUNBQ0YsQ0FBQztnQ0FDRixJQUFJLG1CQUFZLENBQUM7b0NBQ2YsSUFBSSxFQUFFLGVBQWU7b0NBQ3JCLElBQUksRUFBRTt3Q0FDSixJQUFJLGtCQUFXLENBQUM7NENBQ2QsSUFBSSxFQUFFLE1BQU07NENBQ1osSUFBSSxFQUFFLFFBQVE7eUNBQ2YsQ0FBQzt3Q0FDRixJQUFJLGtCQUFXLENBQUM7NENBQ2QsSUFBSSxFQUFFLGFBQWE7NENBQ25CLElBQUksRUFBRSxRQUFRO3lDQUNmLENBQUM7d0NBQ0YsSUFBSSxrQkFBVyxDQUFDOzRDQUNkLElBQUksRUFBRSxLQUFLOzRDQUNYLElBQUksRUFBRSxRQUFRO3lDQUNmLENBQUM7d0NBQ0YsSUFBSSxrQkFBVyxDQUFDOzRDQUNkLElBQUksRUFBRSxXQUFXOzRDQUNqQixJQUFJLEVBQUUsUUFBUTt5Q0FDZixDQUFDO3dDQUNGLElBQUksa0JBQVcsQ0FBQzs0Q0FDZCxJQUFJLEVBQUUsVUFBVTs0Q0FDaEIsSUFBSSxFQUFFLFFBQVE7eUNBQ2YsQ0FBQztxQ0FDSDtpQ0FDRixDQUFDOzZCQUNIO3lCQUNGLENBQUM7cUJBQ0g7aUJBQ0YsQ0FBQztnQkFDRixJQUFJLGtCQUFXLENBQUM7b0JBQ2QsSUFBSSxFQUFFLFdBQVc7b0JBQ2pCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxhQUFhO29CQUNuQixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsV0FBVztvQkFDakIsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQztnQkFDRixJQUFJLGtCQUFXLENBQUM7b0JBQ2QsSUFBSSxFQUFFLFdBQVc7b0JBQ2pCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxpQkFBaUI7b0JBQ3ZCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxXQUFXO29CQUNqQixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsV0FBVztvQkFDakIsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQztnQkFDRixJQUFJLGtCQUFXLENBQUM7b0JBQ2QsSUFBSSxFQUFFLGNBQWM7b0JBQ3BCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxtQkFBbUI7b0JBQ3pCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxrQkFBa0I7b0JBQ3hCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxxQkFBcUI7b0JBQzNCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxXQUFXO29CQUNqQixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsU0FBUztvQkFDZixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsVUFBVTtvQkFDaEIsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQztnQkFDRixJQUFJLGtCQUFXLENBQUM7b0JBQ2QsSUFBSSxFQUFFLFdBQVc7b0JBQ2pCLElBQUksRUFBRSxJQUFJLG1CQUFZLENBQUM7d0JBQ3JCLElBQUksRUFBRTs0QkFDSixJQUFJLGtCQUFXLENBQUM7Z0NBQ2QsSUFBSSxFQUFFLEtBQUs7Z0NBQ1gsSUFBSSxFQUFFLFFBQVE7NkJBQ2YsQ0FBQzs0QkFDRixJQUFJLGtCQUFXLENBQUM7Z0NBQ2QsSUFBSSxFQUFFLFdBQVc7Z0NBQ2pCLElBQUksRUFBRSxRQUFROzZCQUNmLENBQUM7NEJBQ0YsSUFBSSxrQkFBVyxDQUFDO2dDQUNkLElBQUksRUFBRSxNQUFNO2dDQUNaLElBQUksRUFBRSxRQUFROzZCQUNmLENBQUM7eUJBQ0g7cUJBQ0YsQ0FBQztpQkFDSCxDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsV0FBVztvQkFDakIsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQztnQkFDRixJQUFJLGtCQUFXLENBQUM7b0JBQ2QsSUFBSSxFQUFFLFlBQVk7b0JBQ2xCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxvQkFBb0I7b0JBQzFCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxxQkFBcUI7b0JBQzNCLElBQUksRUFBRSxRQUFRO2lCQUNmLENBQUM7Z0JBQ0YsSUFBSSxrQkFBVyxDQUFDO29CQUNkLElBQUksRUFBRSxlQUFlO29CQUNyQixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsZUFBZTtvQkFDckIsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQzthQUNIO1lBQ0QsVUFBVSxFQUFFLEtBQUs7WUFDakIsVUFBVSxFQUFFO2dCQUNWLFdBQVcsRUFBRSxrQkFBVyxDQUFDLFVBQVU7Z0JBQ25DLFlBQVksRUFBRSxtQkFBWSxDQUFDLG9CQUFvQjtnQkFDL0Msb0JBQW9CLEVBQUUsMkJBQW9CLENBQUMsVUFBVTthQUN0RDtZQUNELFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixXQUFXLEVBQUUsMENBQTBDO1lBQ3ZELFFBQVEsRUFBRSxRQUFRLEtBQUssQ0FBQyxNQUFNLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxRQUFRLElBQUksRUFBRSxVQUFVO1lBQzNFLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixLQUFLLEVBQUUsUUFBUTtZQUNmLFVBQVUsRUFBRTtnQkFDVixVQUFVLEVBQUUsTUFBTTtnQkFDbEIsdUJBQXVCLEVBQUUsWUFBWTtnQkFDckMseUJBQXlCLEVBQUUsR0FBRztnQkFDOUIsc0JBQXNCLEVBQUUsR0FBRyxjQUFjLFlBQVk7Z0JBQ3JELHFCQUFxQixFQUFFLE1BQU07Z0JBQzdCLDhCQUE4QixFQUFFLE1BQU07Z0JBQ3RDLHlCQUF5QixFQUFFLE1BQU07Z0JBQ2pDLDJCQUEyQixFQUFFLFlBQVk7Z0JBQ3pDLDRCQUE0QixFQUFFLE1BQU07Z0JBQ3BDLDhCQUE4QixFQUFFLHdCQUFVLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO29CQUMzRCxPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUM7Z0JBQ2hCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7Z0JBQ1osd0JBQXdCLEVBQUUsTUFBTTtnQkFDaEMsMEJBQTBCLEVBQUUsa0JBQUksQ0FBQyxNQUFNLENBQUM7b0JBQ3RDLE9BQU8sRUFBRSxHQUFHLEVBQUU7d0JBQ1osSUFBSSxtQkFBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxFQUFFOzRCQUMxQyx5QkFBVyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxVQUFVLENBQUM7Z0NBQzlCLDhCQUE4QixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksMkJBQTJCO2dDQUN2RSx3RUFBd0U7Z0NBQ3hFLDJFQUEyRTtnQ0FDM0UsV0FBVyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLFNBQVM7NkJBQ3pDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7NEJBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQzt5QkFDM0I7NkJBQU07NEJBQ0wsT0FBTyxDQUFDLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsRUFBRTtvQ0FDcEUsSUFBSSxDQUFDLEdBQUcsWUFBWSxtQkFBSyxJQUFJLEdBQUcsWUFBWSxtQkFBSyxDQUFDLElBQUksR0FBRyxDQUFDLE9BQU8sSUFBSSxDQUFDLG1CQUFLLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsRUFBRTt3Q0FDckcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLENBQUM7cUNBQ3hCO29DQUVELE9BQU8sSUFBSSxDQUFDO2dDQUNkLENBQUMsRUFBRSxFQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO3lCQUNoQztvQkFDSCxDQUFDO2lCQUNGLENBQUM7Z0JBQ0Ysb0JBQW9CLEVBQUUsTUFBTTtnQkFDNUIsMkJBQTJCLEVBQUUsUUFBUSxLQUFLLENBQUMsTUFBTSxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsUUFBUSxJQUFJLEVBQUUsdURBQXVEO2FBQzVJO1lBQ0QsYUFBYSxFQUFFO2dCQUNiLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsUUFBUTtvQkFDZCxJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsU0FBUztvQkFDZixJQUFJLEVBQUUsUUFBUTtpQkFDZixDQUFDO2dCQUNGLElBQUksa0JBQVcsQ0FBQztvQkFDZCxJQUFJLEVBQUUsWUFBWTtvQkFDbEIsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQztnQkFDRixJQUFJLGtCQUFXLENBQUM7b0JBQ2QsSUFBSSxFQUFFLEtBQUs7b0JBQ1gsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQzthQUNIO1lBQ0QsZUFBZSxFQUFFO2dCQUNmLHNCQUFzQixFQUFFLEdBQUc7YUFDNUI7WUFDRCxzQkFBc0IsRUFBRSxLQUFLO1lBQzdCLFNBQVMsRUFBRSxnQkFBUyxDQUFDLGNBQWM7U0FDcEMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxJQUFJLElBQUksQ0FBQztRQUNqRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixJQUFJLEtBQUssQ0FBQztRQUU1RCxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDdEIsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksbUJBQVUsQ0FBQyxJQUFJLEVBQUUsMEJBQTBCLEVBQUU7Z0JBQzdFLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtnQkFDdkIsV0FBVyxFQUFFLHNEQUFzRDtnQkFDbkUsSUFBSSxFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUMsZ0NBQWdDLENBQUMsQ0FBQyxDQUFDLFNBQVM7Z0JBQzVFLFdBQVcsRUFBRTtvQkFDWCxzRUFBc0U7b0JBQ3RFLGtFQUFrRTtvQkFDbEUsaUNBQWlDO29CQUNqQywyQ0FBMkM7b0JBQzNDLHVDQUF1QztvQkFDdkMsZ0JBQWdCO29CQUNoQixtQkFBbUI7b0JBQ25CLGlDQUFpQztvQkFDakMsUUFBUSxJQUFJLENBQUMsU0FBUyxFQUFFO29CQUN4QixtRkFBbUY7b0JBQ25GLHNFQUFzRTtvQkFDdEUsMkVBQTJFO29CQUMzRSxvQ0FBb0M7aUJBQ3JDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQzthQUNiLENBQUMsQ0FBQztZQUVILElBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLG1CQUFVLENBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFO2dCQUMxRSxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7Z0JBQ3ZCLFdBQVcsRUFBRSwyQ0FBMkM7Z0JBQ3hELElBQUksRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUNwRSxXQUFXLEVBQUU7b0JBQ1gsc0VBQXNFO29CQUN0RSxrRUFBa0U7b0JBQ2xFLHdDQUF3QztvQkFDeEMsd0NBQXdDO29CQUN4QyxlQUFlO29CQUNmLFFBQVEsSUFBSSxDQUFDLFNBQVMsRUFBRTtvQkFDeEIsa0NBQWtDO29CQUNsQyx1RUFBdUU7b0JBQ3ZFLDRFQUE0RTtvQkFDNUUsb0NBQW9DO2lCQUNyQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7YUFDYixDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBeFVILDBDQXlVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFubm90YXRpb25zLCBMYXp5LCBSZXNvdXJjZVByb3BzLCBTdGFjaywgU3RhZ2UsIFRva2VuIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgSUJ1Y2tldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBSZWdpb25JbmZvIH0gZnJvbSAnYXdzLWNkay1saWIvcmVnaW9uLWluZm8nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBOYW1lZFF1ZXJ5IH0gZnJvbSAnLi4vYXRoZW5hJztcbmltcG9ydCB7IEFycmF5Q29sdW1uLCBCYXNpY0NvbHVtbiwgRGF0YWJhc2UsIElucHV0Rm9ybWF0LCBPdXRwdXRGb3JtYXQsIFNlcmlhbGl6YXRpb25MaWJyYXJ5LCBTdHJ1Y3RDb2x1bW4sIFRhYmxlLCBUYWJsZVR5cGUgfSBmcm9tICcuLi9nbHVlJztcblxuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gZm9yIEZsb3dMb2dzVGFibGVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDbG91ZHRyYWlsVGFibGVQcm9wcyBleHRlbmRzIFJlc291cmNlUHJvcHMge1xuICAvKipcbiAgICogQSBidWNrZXQgd2hlcmUgbG9ncyB3aWxsIGJlIHN0b3JlZFxuICAgKlxuICAgKiBAc2VlIFtBV1MgUzMgaUJ1Y2tldF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvdjIvZG9jcy9hd3MtY2RrLWxpYi5hd3NfczMuSUJ1Y2tldC5odG1sKVxuICAgKi9cbiAgcmVhZG9ubHkgYnVja2V0OiBJQnVja2V0O1xuICAvKipcbiAgICAqIEJvb2xlYW4gaW5kaWNhdGluZyB3aGV0aGVyIHRvIGNyZWF0ZSBkZWZhdWx0IEF0aGVuYSBxdWVyaWVzIGZvciB0aGUgQ2xvdWR0cmFpbCBMb2dzXG4gICAgKlxuICAgICogQHNlZSBbYENmbk5hbWVkUXVlcmllc2BdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvYXBpL3YxL3B5dGhvbi9hd3NfY2RrLmF3c19hdGhlbmEvQ2ZuTmFtZWRRdWVyeS5odG1sKVxuICAgICovXG4gIHJlYWRvbmx5IGNyZWF0ZVF1ZXJpZXM/OiBib29sZWFuO1xuICAvKipcbiAgICogQSBjZGstZXh0ZW5zaW9ucy9nbHVlIHtAbGluayBhd3MtZ2x1ZSFEYXRhYmFzZSB9IG9iamVjdCB0aGF0IHRoZSB0YWJsZSBzaG91bGQgYmUgY3JlYXRlZCBpbi5cbiAgICpcbiAgICogQHNlZSBbQVdTOjpHbHVlOjpEYXRhYmFzZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWdsdWUtZGF0YWJhc2UuaHRtbClcbiAgICovXG4gIHJlYWRvbmx5IGRhdGFiYXNlOiBEYXRhYmFzZTtcbiAgLyoqXG4gICAgKiBCb29sZWFuIGZvciBhZGRpbmcgXCJmcmllbmRseSBuYW1lc1wiIGZvciB0aGUgY3JlYXRlZCBBdGhlbmEgcXVlcmllcy5cbiAgICAqL1xuICByZWFkb25seSBmcmllbmRseVF1ZXJ5TmFtZXM/OiBib29sZWFuO1xuICAvKipcbiAgICAqIE5hbWUgZm9yIENsb3VkdHJhaWwgTG9ncyBUYWJsZVxuICAgICovXG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAgICogU2V0IGEgY3VzdG9tIHByZWZpeCBmb3IgdGhlIFMzIEJ1Y2tldFxuICAgICovXG4gIHJlYWRvbmx5IHMzUHJlZml4Pzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQ2xvdWR0cmFpbFRhYmxlIGV4dGVuZHMgVGFibGUge1xuICAvLyBJbnB1dCBwcm9wZXJ0aWVzXG4gIC8qKlxuICAgICogQm9vbGVhbiBpbmRpY2F0aW5nIHdoZXRoZXIgdG8gY3JlYXRlIGRlZmF1bHQgQXRoZW5hIHF1ZXJpZXMgZm9yIHRoZSBDbG91ZHRyYWlsIExvZ3NcbiAgICAqXG4gICAgKiBAc2VlIFtgQ2ZuTmFtZWRRdWVyaWVzYF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvdjEvcHl0aG9uL2F3c19jZGsuYXdzX2F0aGVuYS9DZm5OYW1lZFF1ZXJ5Lmh0bWwpXG4gICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNyZWF0ZVF1ZXJpZXM6IGJvb2xlYW47XG4gIC8qKlxuICAgICogQm9vbGVhbiBmb3IgYWRkaW5nIFwiZnJpZW5kbHkgbmFtZXNcIiBmb3IgdGhlIGNyZWF0ZWQgQXRoZW5hIHF1ZXJpZXMuXG4gICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGZyaWVuZGx5UXVlcnlOYW1lczogYm9vbGVhbjtcblxuICAvLyBSZXNvdXJjZSBwcm9wZXJ0aWVzXG4gIHB1YmxpYyByZWFkb25seSB1bmF1dGhvcml6ZWROYW1lZFF1ZXJ5PzogTmFtZWRRdWVyeTtcbiAgcHVibGljIHJlYWRvbmx5IHVzZXJMb2dpbnNOYW1lZFF1ZXJ5PzogTmFtZWRRdWVyeTtcblxuXG4gIC8qKlxuICAgICAqIENyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIEZsb3dMb2dzVGFibGUgY2xhc3MuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gc2NvcGUgQSBDREsgQ29uc3RydWN0IHRoYXQgd2lsbCBzZXJ2ZSBhcyB0aGlzIHN0YWNrJ3MgcGFyZW50IGluIHRoZSBjb25zdHJ1Y3QgdHJlZS5cbiAgICAgKiBAcGFyYW0gaWQgQSBuYW1lIHRvIGJlIGFzc29jaWF0ZWQgd2l0aCB0aGUgc3RhY2sgYW5kIHVzZWQgaW4gcmVzb3VyY2UgbmFtaW5nLiBNdXN0IGJlIHVuaXF1ZVxuICAgICAqIHdpdGhpbiB0aGUgY29udGV4dCBvZiAnc2NvcGUnLlxuICAgICAqIEBwYXJhbSBwcm9wcyBBcmd1bWVudHMgcmVsYXRlZCB0byB0aGUgY29uZmlndXJhdGlvbiBvZiB0aGUgcmVzb3VyY2UuXG4gICAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDbG91ZHRyYWlsVGFibGVQcm9wcykge1xuICAgIGNvbnN0IHByb2plY3Rpb25ZZWFyID0gbmV3IERhdGUoKS5nZXRGdWxsWWVhcigpIC0gMTtcblxuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgY29sdW1uczogW1xuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdldmVudFZlcnNpb24nLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IFN0cnVjdENvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ3VzZXJJZGVudGl0eScsXG4gICAgICAgICAgZGF0YTogW1xuICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgbmFtZTogJ3R5cGUnLFxuICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgbmFtZTogJ3ByaW5jaXBhbElkJyxcbiAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgICAgIG5hbWU6ICdhcm4nLFxuICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgbmFtZTogJ2FjY291bnRJZCcsXG4gICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgICAgICBuYW1lOiAnaW52b2tlZEJ5JyxcbiAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgICAgIG5hbWU6ICdhY2Nlc3NLZXlJZCcsXG4gICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgICAgICBuYW1lOiAndXNlck5hbWUnLFxuICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgbmV3IFN0cnVjdENvbHVtbih7XG4gICAgICAgICAgICAgIG5hbWU6ICdzZXNzaW9uQ29udGV4dCcsXG4gICAgICAgICAgICAgIGRhdGE6IFtcbiAgICAgICAgICAgICAgICBuZXcgU3RydWN0Q29sdW1uKHtcbiAgICAgICAgICAgICAgICAgIG5hbWU6ICdhdHRyaWJ1dGVzJyxcbiAgICAgICAgICAgICAgICAgIGRhdGE6IFtcbiAgICAgICAgICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgICAgICAgICBuYW1lOiAnbWZhQXV0aGVudGljYXRlZCcsXG4gICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgICAgICAgICAgICAgIG5hbWU6ICdjcmVhdGlvbkRhdGUnLFxuICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAgICAgbmV3IFN0cnVjdENvbHVtbih7XG4gICAgICAgICAgICAgICAgICBuYW1lOiAnc2Vzc2lvbklzc3VlcicsXG4gICAgICAgICAgICAgICAgICBkYXRhOiBbXG4gICAgICAgICAgICAgICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgICAgICAgICAgICAgbmFtZTogJ3R5cGUnLFxuICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgICAgICAgICBuYW1lOiAncHJpbmNpcGFsSWQnLFxuICAgICAgICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgICAgICAgICBuYW1lOiAnYXJuJyxcbiAgICAgICAgICAgICAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAgICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgICAgICAgICAgICAgbmFtZTogJ2FjY291bnRJZCcsXG4gICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgICAgICAgICAgICAgIG5hbWU6ICd1c2VyTmFtZScsXG4gICAgICAgICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdldmVudFRpbWUnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAnZXZlbnRTb3VyY2UnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAnZXZlbnROYW1lJyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ2F3c1JlZ2lvbicsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdzb3VyY2VJcEFkZHJlc3MnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAndXNlckFnZW50JyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ2Vycm9yQ29kZScsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdlcnJvck1lc3NhZ2UnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAncmVxdWVzdFBhcmFtZXRlcnMnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAncmVzcG9uc2VFbGVtZW50cycsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdhZGRpdGlvbmFsRXZlbnREYXRhJyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ3JlcXVlc3RJZCcsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdldmVudElkJyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ3JlYWRPbmx5JyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBBcnJheUNvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ3Jlc291cmNlcycsXG4gICAgICAgICAgZGF0YTogbmV3IFN0cnVjdENvbHVtbih7XG4gICAgICAgICAgICBkYXRhOiBbXG4gICAgICAgICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgICAgICAgbmFtZTogJ2FybicsXG4gICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgICAgICAgIG5hbWU6ICdhY2NvdW50SWQnLFxuICAgICAgICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICAgICAgICBuYW1lOiAndHlwZScsXG4gICAgICAgICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgXSxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ2V2ZW50VHlwZScsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdhcGlWZXJzaW9uJyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ3JlY2lwaWVudEFjY291bnRJZCcsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdzZXJ2aWNlRXZlbnREZXRhaWxzJyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ3NoYXJlZEV2ZW50SUQnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAndnBjZW5kcG9pbnRpZCcsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgXSxcbiAgICAgIGNvbXByZXNzZWQ6IGZhbHNlLFxuICAgICAgZGF0YUZvcm1hdDoge1xuICAgICAgICBpbnB1dEZvcm1hdDogSW5wdXRGb3JtYXQuQ0xPVURUUkFJTCxcbiAgICAgICAgb3V0cHV0Rm9ybWF0OiBPdXRwdXRGb3JtYXQuSElWRV9JR05PUkVfS0VZX1RFWFQsXG4gICAgICAgIHNlcmlhbGl6YXRpb25MaWJyYXJ5OiBTZXJpYWxpemF0aW9uTGlicmFyeS5DTE9VRFRSQUlMLFxuICAgICAgfSxcbiAgICAgIGRhdGFiYXNlOiBwcm9wcy5kYXRhYmFzZSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnVGFibGUgdXNlZCBmb3IgcXVlcnlpbmcgQVdTIEFQSSBoaXN0b3J5LicsXG4gICAgICBsb2NhdGlvbjogYHMzOi8vJHtwcm9wcy5idWNrZXQuYnVja2V0TmFtZX0vJHtwcm9wcy5zM1ByZWZpeCA/PyAnJ31BV1NMb2dzL2AsXG4gICAgICBuYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgb3duZXI6ICdoYWRvb3AnLFxuICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAnRVhURVJOQUwnOiAnVFJVRScsXG4gICAgICAgICdwcm9qZWN0aW9uLmRheS5mb3JtYXQnOiAneXl5eS9NTS9kZCcsXG4gICAgICAgICdwcm9qZWN0aW9uLmRheS5pbnRlcnZhbCc6ICcxJyxcbiAgICAgICAgJ3Byb2plY3Rpb24uZGF5LnJhbmdlJzogYCR7cHJvamVjdGlvblllYXJ9LzAxLzAxLE5PV2AsXG4gICAgICAgICdwcm9qZWN0aW9uLmRheS50eXBlJzogJ2RhdGUnLFxuICAgICAgICAncHJvamVjdGlvbi5kYXkuaW50ZXJ2YWwudW5pdCc6ICdEQVlTJyxcbiAgICAgICAgJ3Byb2plY3Rpb24ubG9nbmFtZS50eXBlJzogJ2VudW0nLFxuICAgICAgICAncHJvamVjdGlvbi5sb2duYW1lLnZhbHVlcyc6ICdDbG91ZFRyYWlsJyxcbiAgICAgICAgJ3Byb2plY3Rpb24ucmVnaW9ubmFtZS50eXBlJzogJ2VudW0nLFxuICAgICAgICAncHJvamVjdGlvbi5yZWdpb25uYW1lLnZhbHVlcyc6IFJlZ2lvbkluZm8ucmVnaW9ucy5tYXAoKHgpID0+IHtcbiAgICAgICAgICByZXR1cm4geC5uYW1lO1xuICAgICAgICB9KS5qb2luKCcsJyksXG4gICAgICAgICdwcm9qZWN0aW9uLnNvdXJjZS50eXBlJzogJ2VudW0nLFxuICAgICAgICAncHJvamVjdGlvbi5zb3VyY2UudmFsdWVzJzogTGF6eS5zdHJpbmcoe1xuICAgICAgICAgIHByb2R1Y2U6ICgpID0+IHtcbiAgICAgICAgICAgIGlmIChUb2tlbi5pc1VucmVzb2x2ZWQodGhpcy5zdGFjay5hY2NvdW50KSkge1xuICAgICAgICAgICAgICBBbm5vdGF0aW9ucy5vZih0aGlzKS5hZGRXYXJuaW5nKFtcbiAgICAgICAgICAgICAgICBgQ2xvdWRUcmFpbCB0YWJsZSBzdGFjayBmb3IgJHt0aGlzLm5vZGUucGF0aH0gaXMgZW52aXJvbm1lbnQgYWdub3N0aWMuYCxcbiAgICAgICAgICAgICAgICAnQ3Jvc3MgYWNjb3VudCBwYXJ0aXRpb24gcHJvamVjdGlvbiBjYW5ub3QgYmUgY29uZmlndXJlZCBvbiBlbnZpcm9ubWVudCcsXG4gICAgICAgICAgICAgICAgJ2Fnbm9zdGljIHN0YWNrcy4gVG8gZW5hYmxlIHBhcnRpdGlvbiBwcm9qZWN0aW9uIHBsZWFzZSBzcGVjaWZ5IGFuIGFjY291bnQnLFxuICAgICAgICAgICAgICAgIGBmb3IgdGhlICR7dGhpcy5zdGFjay5ub2RlLnBhdGh9IHN0YWNrLmAsXG4gICAgICAgICAgICAgIF0uam9pbignICcpKTtcbiAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RhY2suYWNjb3VudDtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgIHJldHVybiBbLi4ubmV3IFNldCh0aGlzLm5vZGUucm9vdC5ub2RlLmZpbmRBbGwoKS5yZWR1Y2UoKHByZXYsIGN1cikgPT4ge1xuICAgICAgICAgICAgICAgIGlmICgoY3VyIGluc3RhbmNlb2YgU3RhZ2UgfHwgY3VyIGluc3RhbmNlb2YgU3RhY2spICYmIGN1ci5hY2NvdW50ICYmICFUb2tlbi5pc1VucmVzb2x2ZWQoY3VyLmFjY291bnQpKSB7XG4gICAgICAgICAgICAgICAgICBwcmV2LnB1c2goY3VyLmFjY291bnQpO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHJldHVybiBwcmV2O1xuICAgICAgICAgICAgICB9LCBbXSBhcyBzdHJpbmdbXSkpXS5qb2luKCcsJyk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSxcbiAgICAgICAgfSksXG4gICAgICAgICdwcm9qZWN0aW9uLmVuYWJsZWQnOiAndHJ1ZScsXG4gICAgICAgICdzdG9yYWdlLmxvY2F0aW9uLnRlbXBsYXRlJzogYHMzOi8vJHtwcm9wcy5idWNrZXQuYnVja2V0TmFtZX0vJHtwcm9wcy5zM1ByZWZpeCA/PyAnJ31BV1NMb2dzL1xcJHtzb3VyY2V9L1xcJHtsb2duYW1lfS9cXCR7cmVnaW9ubmFtZX0vXFwke2RheX1gLFxuICAgICAgfSxcbiAgICAgIHBhcnRpdGlvbktleXM6IFtcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAnc291cmNlJyxcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBCYXNpY0NvbHVtbih7XG4gICAgICAgICAgbmFtZTogJ2xvZ25hbWUnLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgICAgbmV3IEJhc2ljQ29sdW1uKHtcbiAgICAgICAgICBuYW1lOiAncmVnaW9ubmFtZScsXG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgQmFzaWNDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6ICdkYXknLFxuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9KSxcbiAgICAgIF0sXG4gICAgICBzZXJkZVBhcmFtZXRlcnM6IHtcbiAgICAgICAgJ3NlcmlhbGl6YXRpb24uZm9ybWF0JzogJzEnLFxuICAgICAgfSxcbiAgICAgIHN0b3JlZEFzU3ViRGlyZWN0b3JpZXM6IGZhbHNlLFxuICAgICAgdGFibGVUeXBlOiBUYWJsZVR5cGUuRVhURVJOQUxfVEFCTEUsXG4gICAgfSk7XG5cbiAgICB0aGlzLmNyZWF0ZVF1ZXJpZXMgPSBwcm9wcy5jcmVhdGVRdWVyaWVzID8/IHRydWU7XG4gICAgdGhpcy5mcmllbmRseVF1ZXJ5TmFtZXMgPSBwcm9wcy5mcmllbmRseVF1ZXJ5TmFtZXMgPz8gZmFsc2U7XG5cbiAgICBpZiAodGhpcy5jcmVhdGVRdWVyaWVzKSB7XG4gICAgICB0aGlzLnVuYXV0aG9yaXplZE5hbWVkUXVlcnkgPSBuZXcgTmFtZWRRdWVyeSh0aGlzLCAndW5hdXRob3JpemVkLW5hbWVkLXF1ZXJ5Jywge1xuICAgICAgICBkYXRhYmFzZTogdGhpcy5kYXRhYmFzZSxcbiAgICAgICAgZGVzY3JpcHRpb246ICdHZXRzIHRoZSAxMDAgbW9zdCByZWNlbnQgdW5hdXRob3JpemVkIEFXUyBBUEkgY2FsbHMuJyxcbiAgICAgICAgbmFtZTogdGhpcy5mcmllbmRseVF1ZXJ5TmFtZXMgPyAnY2xvdWR0cmFpbC11bmF1dGhvcml6ZWQtZXJyb3JzJyA6IHVuZGVmaW5lZCxcbiAgICAgICAgcXVlcnlTdHJpbmc6IFtcbiAgICAgICAgICBcIlNFTEVDVCBGUk9NX0lTTzg2MDFfVElNRVNUQU1QKGV2ZW50dGltZSkgQVQgVElNRSBaT05FICdVVEMnIEFTIHRpbWUsXCIsXG4gICAgICAgICAgXCIgICAgQ09OQ0FUKFNQTElUKGV2ZW50c291cmNlLCAnLicpWzFdLCAnOicsIGV2ZW50bmFtZSkgQVMgZXZlbnQsXCIsXG4gICAgICAgICAgJyAgICB1c2VyaWRlbnRpdHkuYXJuIGFzIGVudGl0eSwnLFxuICAgICAgICAgICcgICAgdXNlcmlkZW50aXR5LmFjY291bnRpZCBhcyBzcmNhY2NvdW50LCcsXG4gICAgICAgICAgJyAgICByZWNpcGllbnRhY2NvdW50aWQgYXMgZHN0YWNjb3VudCwnLFxuICAgICAgICAgICcgICAgYXdzcmVnaW9uLCcsXG4gICAgICAgICAgJyAgICBlcnJvcm1lc3NhZ2UsJyxcbiAgICAgICAgICAnICAgIHJlcXVlc3RwYXJhbWV0ZXJzIGFzIHBhcmFtcycsXG4gICAgICAgICAgYEZST00gJHt0aGlzLnRhYmxlTmFtZX1gLFxuICAgICAgICAgIFwiV0hFUkUgKGVycm9yY29kZSBMSUtFICdBY2Nlc3NEZW5pZWQlJyBPUiBlcnJvcmNvZGUgTElLRSAnJVVuYXV0aG9yaXplZE9wZXJhdGlvbicpXCIsXG4gICAgICAgICAgXCIgICAgQU5EIGRheSA+PSBEQVRFX0ZPUk1BVChOT1coKSAtIFBBUlNFX0RVUkFUSU9OKCcxZCcpLCAnJVkvJW0vJWQnKVwiLFxuICAgICAgICAgIFwiICAgIEFORCBGUk9NX0lTTzg2MDFfVElNRVNUQU1QKGV2ZW50dGltZSkgPj0gTk9XKCkgLSBQQVJTRV9EVVJBVElPTignMWQnKVwiLFxuICAgICAgICAgICdPUkRFUiBCWSBldmVudHRpbWUgREVTQyBMSU1JVCAxMDA7JyxcbiAgICAgICAgXS5qb2luKCdcXG4nKSxcbiAgICAgIH0pO1xuXG4gICAgICB0aGlzLnVzZXJMb2dpbnNOYW1lZFF1ZXJ5ID0gbmV3IE5hbWVkUXVlcnkodGhpcywgJ3VzZXItbG9naW5zLW5hbWVkLXF1ZXJ5Jywge1xuICAgICAgICBkYXRhYmFzZTogdGhpcy5kYXRhYmFzZSxcbiAgICAgICAgZGVzY3JpcHRpb246ICdHZXRzIHRoZSAxMDAgbW9zdCByZWNlbnQgQVdTIHVzZXIgbG9naW5zLicsXG4gICAgICAgIG5hbWU6IHRoaXMuZnJpZW5kbHlRdWVyeU5hbWVzID8gJ2Nsb3VkdHJhaWwtdXNlci1sb2dpbnMnIDogdW5kZWZpbmVkLFxuICAgICAgICBxdWVyeVN0cmluZzogW1xuICAgICAgICAgIFwiU0VMRUNUIEZST01fSVNPODYwMV9USU1FU1RBTVAoZXZlbnR0aW1lKSBBVCBUSU1FIFpPTkUgJ1VUQycgQVMgdGltZSxcIixcbiAgICAgICAgICBcIiAgICBDT05DQVQoU1BMSVQoZXZlbnRzb3VyY2UsICcuJylbMV0sICc6JywgZXZlbnRuYW1lKSBBUyBldmVudCxcIixcbiAgICAgICAgICAnICAgIHVzZXJpZGVudGl0eS51c2VybmFtZSBhcyB1c2VybmFtZSwnLFxuICAgICAgICAgICcgICAgdXNlcmlkZW50aXR5LmFjY291bnRpZCBhcyBhY2NvdW50LCcsXG4gICAgICAgICAgJyAgICBhd3NyZWdpb24nLFxuICAgICAgICAgIGBGUk9NICR7dGhpcy50YWJsZU5hbWV9YCxcbiAgICAgICAgICBcIldIRVJFIGV2ZW50bmFtZSA9ICdDb25zb2xlTG9naW4nXCIsXG4gICAgICAgICAgXCIgICAgQU5EIGRheSA+PSBEQVRFX0ZPUk1BVChOT1coKSAtIFBBUlNFX0RVUkFUSU9OKCczMGQnKSwgJyVZLyVtLyVkJylcIixcbiAgICAgICAgICBcIiAgICBBTkQgRlJPTV9JU084NjAxX1RJTUVTVEFNUChldmVudHRpbWUpID49IE5PVygpIC0gUEFSU0VfRFVSQVRJT04oJzMwZCcpXCIsXG4gICAgICAgICAgJ09SREVSIEJZIGV2ZW50dGltZSBERVNDIExJTUlUIDEwMDsnLFxuICAgICAgICBdLmpvaW4oJ1xcbicpLFxuICAgICAgfSk7XG4gICAgfVxuICB9XG59XG4iXX0=