"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3AccessLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class S3AccessLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the S3AccessLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'bucket_owner',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'bucket_name',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_datetime',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'remote_ip',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'requester',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'operation',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'key',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_uri',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'http_status',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'error_code',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'bytes_sent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'object_size',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'total_time',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'turnaround_time',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'referrer',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'user_agent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'version_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'host_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'sigv',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'cipher_suite',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'auth_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'endpoint',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'tls_version',
                    type: 'string',
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.REGEXP,
            },
            database: props.database,
            description: 'Table used for querying S3 access logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                EXTERNAL: 'TRUE',
            },
            serdeParameters: {
                'input.regex': '([^ ]*) ([^ ]*) \\[(.*?)\\] ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) (\"[^\"]*\"|-) (-|[0-9]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) (\"[^\"]*\"|-) ([^ ]*)(?: ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*))?.*$',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.requestErrorsNamedQuery = new athena_1.NamedQuery(this, 'reqest-errors-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent failed S3 access requests.',
                name: this.friendlyQueryNames ? 's3-request-errors' : undefined,
                queryString: [
                    'SELECT PARSE_DATETIME(request_datetime, \'d/MMM/y:H:m:s Z\') AT TIME ZONE \'UTC\' AS "timestamp",',
                    '    remote_ip AS client_ip,',
                    '    http_status AS status_code,',
                    '    error_code,',
                    '    operation,',
                    '    request_id,',
                    '    CASE',
                    "        WHEN key = '-' THEN CONCAT('s3://', bucket_name, '/')",
                    "        ELSE CONCAT('s3://', bucket_name, '/', key)",
                    '    END AS object',
                    `FROM ${this.tableName}`,
                    'WHERE CAST(http_status AS integer) BETWEEN 400 AND 599',
                    "    AND PARSE_DATETIME(request_datetime, 'd/MMM/y:H:m:s Z') >= NOW() - PARSE_DURATION('1d')",
                    'ORDER BY "timestamp" DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.S3AccessLogsTable = S3AccessLogsTable;
_a = JSII_RTTI_SYMBOL_1;
S3AccessLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.S3AccessLogsTable", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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