"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class SesLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the SesLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        const projectionYear = new Date().getFullYear() - 1;
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'eventType',
                    type: 'string',
                }),
                new glue_1.StructColumn({
                    name: 'complaint',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'arrivaldate',
                            type: 'string',
                        }),
                        new glue_1.ArrayColumn({
                            name: 'complainedrecipients',
                            data: new glue_1.StructColumn({
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'emailaddress',
                                        type: 'string',
                                    }),
                                ],
                            }),
                        }),
                        new glue_1.BasicColumn({
                            name: 'complaintfeedbacktype',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'feedbackid',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'timestamp',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'useragent',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.StructColumn({
                    name: 'bounce',
                    data: [
                        new glue_1.ArrayColumn({
                            name: 'bouncedrecipients',
                            data: new glue_1.StructColumn({
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'action',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'diagnosticcode',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'emailaddress',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'status',
                                        type: 'string',
                                    }),
                                ],
                            }),
                        }),
                        new glue_1.BasicColumn({
                            name: 'bouncesubtype',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'bouncetype',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'feedbackid',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'reportingmta',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'timestamp',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.StructColumn({
                    name: 'mail',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'timestamp',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'source',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'sourceArn',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'sendingAccountId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'messageId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'destination',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'headersTruncated',
                            type: 'string',
                        }),
                        new glue_1.ArrayColumn({
                            name: 'headers',
                            data: new glue_1.StructColumn({
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'name',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'value',
                                        type: 'string',
                                    }),
                                ],
                            }),
                        }),
                        new glue_1.StructColumn({
                            name: 'commonHeaders',
                            data: [
                                new glue_1.ArrayColumn({
                                    name: 'from',
                                    data: new glue_1.BasicColumn({
                                        type: 'string',
                                    }),
                                }),
                                new glue_1.ArrayColumn({
                                    name: 'to',
                                    data: new glue_1.BasicColumn({
                                        type: 'string',
                                    }),
                                }),
                                new glue_1.BasicColumn({
                                    name: 'messageId',
                                    type: 'string',
                                }),
                                new glue_1.BasicColumn({
                                    name: 'subject',
                                    type: 'string',
                                }),
                            ],
                        }),
                        new glue_1.StructColumn({
                            name: 'tags',
                            data: [
                                new glue_1.BasicColumn({
                                    name: 'ses_configurationset',
                                    type: 'string',
                                }),
                                new glue_1.BasicColumn({
                                    name: 'ses_source_ip',
                                    type: 'string',
                                }),
                                new glue_1.BasicColumn({
                                    name: 'ses_outgoing_ip',
                                    type: 'string',
                                }),
                                new glue_1.BasicColumn({
                                    name: 'ses_from_domain',
                                    type: 'string',
                                }),
                                new glue_1.BasicColumn({
                                    name: 'ses_caller_identity',
                                    type: 'string',
                                }),
                            ],
                        }),
                    ],
                }),
                new glue_1.BasicColumn({
                    name: 'send',
                    type: 'string',
                }),
                new glue_1.StructColumn({
                    name: 'delivery',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'processingtimemillis',
                            type: 'int',
                        }),
                        new glue_1.ArrayColumn({
                            name: 'recipients',
                            data: new glue_1.BasicColumn({
                                type: 'string',
                            }),
                        }),
                        new glue_1.BasicColumn({
                            name: 'reportingmta',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'smtpresponse',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'timestamp',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.StructColumn({
                    name: 'open',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'ipaddress',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'timestamp',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'userAgent',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.StructColumn({
                    name: 'reject',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'reason',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.StructColumn({
                    name: 'click',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'ipAddress',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'timestamp',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'userAgent',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'link',
                            type: 'string',
                        }),
                    ],
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.OPENX_JSON,
            },
            database: props.database,
            description: 'Table used for querying SES event logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'projection.day.format': 'yyyy/MM/dd',
                'projection.day.interval': '1',
                'projection.day.range': `${projectionYear}/01/01,NOW`,
                'projection.day.type': 'date',
                'projection.day.interval.unit': 'DAYS',
                'projection.enabled': 'true',
                'storage.location.template': `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}\${day}`,
            },
            partitionKeys: [
                new glue_1.BasicColumn({
                    name: 'day',
                    type: 'string',
                }),
            ],
            serdeParameters: {
                'mapping.ses_configurationset': 'ses:configuration-set',
                'mapping.ses_source_ip': 'ses:source-ip',
                'mapping.ses_from_domain': 'ses:from-domain',
                'mapping.ses_caller_identity': 'ses:caller-identity',
                'mapping.ses_outgoing_ip': 'ses:outgoing-ip',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.bouncesQuery = new athena_1.NamedQuery(this, 'bounces-query', {
                database: this.database,
                description: 'Gets the 100 most recent bounces from the last day.',
                name: this.friendlyQueryNames ? 'ses-bounces' : undefined,
                queryString: [
                    "SELECT FROM_ISO8601_TIMESTAMP(bounce.timestamp) AT TIME ZONE 'UTC' AS time,",
                    "    CONCAT(bounce.bouncetype, ' (', bounce.bouncesubtype, ')') AS type,",
                    '    mail.commonheaders.subject AS subject,',
                    '    failed.emailaddress AS failed,',
                    '    failed.diagnosticcode AS reason,',
                    '    ARRAY_JOIN(mail.commonheaders."from", \',\') AS sender,',
                    '    ARRAY_JOIN(mail.commonheaders."to", \',\') AS recipient,',
                    '    bounce.feedbackid AS id',
                    `FROM ${this.tableName}`,
                    'CROSS JOIN UNNEST(bounce.bouncedrecipients) AS t(failed)',
                    "WHERE eventtype = 'Bounce'",
                    "    AND day >= DATE_FORMAT(NOW() - PARSE_DURATION('1d'), '%Y/%m/%d')",
                    'ORDER BY time DESC LIMIT 100;',
                ].join('\n'),
            });
            this.complaintsQuery = new athena_1.NamedQuery(this, 'complaints-query', {
                database: this.database,
                description: 'Gets the 100 most recent complaints from the last day.',
                name: this.friendlyQueryNames ? 'ses-complaints' : undefined,
                queryString: [
                    "SELECT FROM_ISO8601_TIMESTAMP(complaint.arrivaldate) AT TIME ZONE 'UTC' AS time,",
                    '    complaint.complaintfeedbacktype AS type,',
                    '    mail.commonheaders.subject AS subject,',
                    '    reporters.emailaddress AS reporter,',
                    '    ARRAY_JOIN(mail.commonheaders."from", \',\') AS sender,',
                    '    ARRAY_JOIN(mail.commonheaders."to", \',\') AS recipient,',
                    '    complaint.useragent,',
                    '    complaint.feedbackid AS id',
                    `FROM ${this.tableName}`,
                    'CROSS JOIN UNNEST(complaint.complainedrecipients) AS t(reporters)',
                    "WHERE eventtype = 'Complaint'",
                    "    AND day >= DATE_FORMAT(NOW() - PARSE_DURATION('1d'), '%Y/%m/%d')",
                    'ORDER BY time DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.SesLogsTable = SesLogsTable;
_a = JSII_RTTI_SYMBOL_1;
SesLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.SesLogsTable", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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