"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const region_info_1 = require("aws-cdk-lib/region-info");
const glue_1 = require("../glue");
class WafLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the S3AccessLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'timestamp',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'formatversion',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'webaclid',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'terminatingruleid',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'terminatingruletype',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'action',
                    type: 'string',
                }),
                new glue_1.ArrayColumn({
                    name: 'terminatingrulematchdetails',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'conditiontype',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'location',
                                type: 'string',
                            }),
                            new glue_1.ArrayColumn({
                                name: 'matcheddata',
                                data: new glue_1.BasicColumn({
                                    type: 'string',
                                }),
                            }),
                        ],
                    }),
                }),
                new glue_1.BasicColumn({
                    name: 'httpsourcename',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'httpsourceid',
                    type: 'string',
                }),
                new glue_1.ArrayColumn({
                    name: 'rulegrouplist',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'rulegroupid',
                                type: 'string',
                            }),
                            new glue_1.StructColumn({
                                name: 'terminatingrule',
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'ruleid',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'action',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'rulematchdetails',
                                        type: 'string',
                                    }),
                                ],
                            }),
                            new glue_1.ArrayColumn({
                                name: 'nonterminatingmatchingrules',
                                data: new glue_1.BasicColumn({
                                    type: 'string',
                                }),
                            }),
                            new glue_1.BasicColumn({
                                name: 'excludedrules',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.ArrayColumn({
                    name: 'ratebasedrulelist',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'ratebasedruleid',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'limitkey',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'maxrateallowed',
                                type: 'int',
                            }),
                        ],
                    }),
                }),
                new glue_1.ArrayColumn({
                    name: 'nonterminatingmatchingrules',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'ruleid',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'action',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.BasicColumn({
                    name: 'requestheadersinserted',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'responsecodesent',
                    type: 'string',
                }),
                new glue_1.StructColumn({
                    name: 'httprequest',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'clientip',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'country',
                            type: 'string',
                        }),
                        new glue_1.ArrayColumn({
                            name: 'headers',
                            data: new glue_1.StructColumn({
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'name',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'value',
                                        type: 'string',
                                    }),
                                ],
                            }),
                        }),
                        new glue_1.BasicColumn({
                            name: 'uri',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'args',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'httpversion',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'httpmethod',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'requestid',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.ArrayColumn({
                    name: 'labels',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'name',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.StructColumn({
                    name: 'captcharesponse',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'responsecode',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'solvetimestamp',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'failureReason',
                            type: 'string',
                        }),
                    ],
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.OPENX_JSON,
            },
            database: props.database,
            description: 'Table used for querying AWS WAF logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'projection.region.type': 'enum',
                'projection.region.values': region_info_1.RegionInfo.regions.map((x) => {
                    return x.name;
                }).join(','),
                'projection.account.type': 'enum',
                'projection.account.values': aws_cdk_lib_1.Lazy.string({
                    produce: () => {
                        if (aws_cdk_lib_1.Token.isUnresolved(this.stack.account)) {
                            aws_cdk_lib_1.Annotations.of(this).addWarning([
                                `Flow logs table stack for ${this.node.path} is environment agnostic.`,
                                'Cross account partition projection cannot be configured on environment',
                                'agnostic stacks. To enable partition projection please specify an account',
                                `for the ${this.stack.node.path} stack.`,
                            ].join(' '));
                            return this.stack.account;
                        }
                        else {
                            return [...new Set(this.node.root.node.findAll().reduce((prev, cur) => {
                                    if ((cur instanceof aws_cdk_lib_1.Stage || cur instanceof aws_cdk_lib_1.Stack) && cur.account && !aws_cdk_lib_1.Token.isUnresolved(cur.account)) {
                                        prev.push(cur.account);
                                    }
                                    return prev;
                                }, []))].join(',');
                        }
                    },
                }),
                'projection.enabled': 'true',
                'storage.location.template': `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/\${account}/WAFLogs/\${region}/`,
            },
            partitionKeys: [
                new glue_1.BasicColumn({
                    name: 'account',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'region',
                    type: 'string',
                }),
            ],
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
    }
}
exports.WafLogsTable = WafLogsTable;
_a = JSII_RTTI_SYMBOL_1;
WafLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.WafLogsTable", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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