import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Connections, IConnectable, ISecurityGroup, IVpc, SecurityGroup, SubnetSelection } from 'aws-cdk-lib/aws-ec2';
import { CfnConnection } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
export declare enum ConnectionType {
    /**
     * JDBC - Designates a connection to a database through Java Database Connectivity (JDBC).
     */
    JDBC = "JDBC",
    /**
     * KAFKA - Designates a connection to an Apache Kafka streaming platform.
     */
    KAFKA = "KAFKA",
    /**
     * MONGODB - Designates a connection to a MongoDB document database.
     */
    MONGODB = "MONGODB",
    /**
     * NETWORK - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
     */
    NETWORK = "NETWORK"
}
/**
 * Configuration for the Glue Workflow resource.
 */
export interface ConnectionProps extends ResourceProps {
    /**
     * The type of the connection.
     *
     * @see [AWS::Glue::Connection ConnectionInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectiontype)
     */
    readonly connectionType: ConnectionType;
    /**
     * A description for the Connection.
     */
    readonly description?: string;
    /**
     * The name of the connection. Connection will not function as expected without a name.
     *
     * @see [AWS::Glue::Connection ConnectionInput](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-name)
     */
    readonly name?: string;
    /**
     * List of Key/Value pairs defining the properties of the Connection
     *
     * @see [AWS::Glue::Connection Properties](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#Properties)
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Existing Security Group to assign to the Connection. If none is provided a new Security Group will be created.
     */
    readonly securityGroups?: ISecurityGroup[];
    /**
     * Options for selection of subnets from the VPC to attach to the Connection
     *
     * @see [CDK SubnetSelection](https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.SubnetSelection.html)
     */
    readonly subnets?: SubnetSelection;
    /**
     * VPC to attach to the Connection
     *
     * @see [IVpc Interface](https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2.IVpc.html)
     */
    readonly vpc?: IVpc;
}
/**
 * Creates a resource specifying a Glue Connection to a data source.
 *
 * @see [AWS::Glue::Connection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html)
 */
export declare class Connection extends Resource implements IConnectable {
    private readonly _matchCriteria;
    private readonly _properties;
    /**
      * {@link ConnectionProps.connectionType:}
      */
    readonly connectionType: ConnectionType;
    /**
      * {@link ConnectionProps.description}
      */
    readonly description?: string;
    /**
      * {@link ConnectionProps.name}
      */
    readonly name?: string;
    /**
      * {@link ConnectionProps.securityGroups:}
      */
    readonly securityGroups: ISecurityGroup[];
    /**
      * {@link ConnectionProps.subnets}
      */
    readonly subnets?: SubnetSelection;
    /**
      * {@link ConnectionProps.vpc}
      */
    readonly vpc?: IVpc;
    readonly resource: CfnConnection;
    readonly securityGroup?: SecurityGroup;
    readonly connectionArn: string;
    readonly connectionName: string;
    readonly connections: Connections;
    /**
   * Creates a new instance of the Connection class
   *
   * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
   */
    constructor(scope: Construct, id: string, props: ConnectionProps);
    addMatchCriteria(value: string): void;
    addProperty(key: string, value: string): void;
}
