import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { CfnCrawler } from 'aws-cdk-lib/aws-glue';
import { Role } from 'aws-cdk-lib/aws-iam';
import { Construct, IConstruct } from 'constructs';
import { Database } from './database';
import { SecurityConfiguration } from './security-configuration';
export declare enum ConfigurationVersion {
    V1_0 = 1
}
export declare enum DeleteBehavior {
    DELETE_FROM_DATABASE = "DELETE_FROM_DATABASE",
    DEPRECATE_IN_DATABASE = "DEPRECATE_IN_DATABASE",
    LOG = "LOG"
}
export declare enum PartitionUpdateBehavior {
    INHERIT_FROM_TABLE = "InheritFromTable"
}
export declare enum RecrawlBehavior {
    EVENT_MODE = "CRAWL_EVENT_MODE",
    EVERYTHING = "CRAWL_EVERYTHING",
    NEW_FOLDERS_ONLY = "CRAWL_NEW_FOLDERS_ONLY"
}
export declare enum TableGroupingPolicy {
    COMBINE_COMPATIBLE_SCHEMAS = "CombineCompatibleSchemas"
}
export declare enum TableUpdateBehavior {
    MERGE_NEW_COLUMNS = "MergeNewColumns"
}
export declare enum UpdateBehavior {
    UPDATE_IN_DATABASE = "UPDATE_IN_DATABASE",
    LOG = "LOG"
}
export interface CrawlerConfiguration {
    readonly partitionUpdateBehavior?: PartitionUpdateBehavior;
    readonly tableGroupingPolicy?: TableGroupingPolicy;
    readonly tableLevel?: number;
    readonly tableUpdateBehavior?: TableUpdateBehavior;
    readonly version?: ConfigurationVersion;
}
export interface CrawlerTargetCollection {
    readonly catalogTargets?: CfnCrawler.CatalogTargetProperty[];
    readonly dynamoDbTargets?: CfnCrawler.DynamoDBTargetProperty[];
    readonly jdbcTargets?: CfnCrawler.JdbcTargetProperty[];
    readonly s3Targets?: CfnCrawler.S3TargetProperty[];
}
export interface ICrawlerTarget {
    bind(crawler: Crawler): CrawlerTargetCollection;
}
export interface ICrawler extends IConstruct {
    /**
     * The Amazon Resource Name (ARN) of the crawler.
     */
    readonly crawlerArn: string;
    /**
     * The name of the crawler.
     */
    readonly crawlerName: string;
}
declare abstract class CrawlerBase extends Resource implements ICrawler {
    /**
     * The Amazon Resource Name (ARN) of the crawler.
     */
    abstract readonly crawlerArn: string;
    /**
     * The name of the crawler.
     */
    abstract readonly crawlerName: string;
}
/**
 * Configuration for Crawler
 */
export interface CrawlerProps extends ResourceProps {
    /**
     * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
     *
     * @see [AWS::Glue::Crawler](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers)
     */
    readonly classifiers?: string[];
    /**
     * Crawler configuration information. This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see Configuring a Crawler.
     *
     * @see [AWS::Glue::Crawler](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration)
     */
    readonly configuration?: CrawlerConfiguration;
    /**
     * The {@link aws-glue.Database | Database } object in which the crawler's output is stored.
     */
    readonly database?: Database;
    /**
     * The deletion behavior when the crawler finds a deleted object.
     *
     * @see [AWS::Glue::Crawler SchemaChangePolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-deletebehavior)
     */
    readonly deleteBehavior?: DeleteBehavior;
    /**
     * Description of the Crawler
     */
    readonly description?: string;
    /**
     * Name of the Crawler
     */
    readonly name?: string;
    /**
     * When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
     *
     * @see [AWS::Glue::Crawler RecrawlPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-recrawlpolicy.html)
     */
    readonly recrawlBehavior?: RecrawlBehavior;
    /**
     * A {@link aws-glue.SecurityConfiguration | SecurityConfiguration } object to apply to the Crawler
     */
    readonly securityConfiguration?: SecurityConfiguration;
    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     *
     * @see [AWS::Glue::Crawler Schedule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html)
     */
    readonly scheduleExpression?: Schedule;
    /**
     * The prefix added to the names of tables that are created.
     *
     * @see [AWS::Glue::Crawler](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix)
     */
    readonly tablePrefix?: string;
    /**
     * A collection of targets to crawl.
     *
     * @see [AWS::Glue::Crawler](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets)
     */
    readonly targets?: ICrawlerTarget[];
    /**
     * The update behavior when the crawler finds a changed schema.
     *
     * @see [AWS::Glue::Crawler SchemaChangePolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-updatebehavior)
     */
    readonly updateBehavior?: UpdateBehavior;
}
/**
 * Create a Crawler resource to pull information from the provided resource.
 *
 * @see [AWS::Glue::Crawler](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html)
 */
export declare class Crawler extends CrawlerBase {
    /**
     * Imports an existing crawler using its Amazon Resource Name (ARN).
     *
     * @param scope A CDK Construct that will serve as this resource's parent in
     * the construct tree.
     * @param id A name to be associated with the stack and used in resource
     * naming. Must be unique within the context of 'scope'.
     * @param crawlerArn The ARN of the crawler to import.
     * @returns An object representing the crawler that was imported.
     */
    static fromCrawlerArn(scope: IConstruct, id: string, crawlerArn: string): ICrawler;
    /**
     * Imports an existing crawler using its name.
     *
     * @param scope A CDK Construct that will serve as this resource's parent in
     * the construct tree.
     * @param id A name to be associated with the stack and used in resource
     * naming. Must be unique within the context of 'scope'.
     * @param crawlerName The name of the crawler to import.
     * @returns An object representing the crawler that was imported.
     */
    static fromCrawlerName(scope: IConstruct, id: string, crawlerName: string): ICrawler;
    private readonly _classifiers;
    private readonly _targets;
    /**
      * {@link CrawlerProps.configuration}
      */
    readonly configuration?: CrawlerConfiguration;
    /**
      * {@link CrawlerProps.database}
      */
    readonly database?: Database;
    /**
      * {@link CrawlerProps.deleteBehavior}
      */
    readonly deleteBehavior?: DeleteBehavior;
    /**
      * {@link CrawlerProps.description}
      */
    readonly description?: string;
    /**
      * {@link CrawlerProps.name}
      */
    readonly name?: string;
    /**
      * {@link CrawlerProps.recrawlBehavior}
      */
    readonly recrawlBehavior?: RecrawlBehavior;
    /**
      * {@link CrawlerProps.scheduleExpression}
      */
    readonly scheduleExpression?: Schedule;
    /**
      * {@link CrawlerProps.securityConfiguration}
      */
    readonly securityConfiguration?: SecurityConfiguration;
    /**
      * {@link CrawlerProps.tablePrefix}
      */
    readonly tablePrefix?: string;
    /**
      * {@link CrawlerProps.updateBehavior}
      */
    readonly updateBehavior?: UpdateBehavior;
    readonly role: Role;
    readonly resource: CfnCrawler;
    readonly crawlerArn: string;
    readonly crawlerName: string;
    /**
     * Creates a new instance of the Crawler class.
     *
     * @param scope A CDK Construct that will serve as this resource's parent in
     * the construct tree.
     * @param id A name to be associated with the stack and used in resource
     * naming. Must be unique within the context of 'scope'.
     * @param props Arguments related to the configuration of the resource.
     */
    constructor(scope: Construct, id: string, props: CrawlerProps);
    addClassifier(classifier: string): void;
    addTarget(target: ICrawlerTarget): void;
    private renderConfiguration;
    private renderTargets;
}
export {};
