"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * Creates a Glue Database resource to contain a collection of metadata Tables
 *
 * @see [AWS::Glue::Database](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
class Database extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the Database class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.description = props?.description;
        this.locationUri = props?.locationUri;
        this.name = props?.name ?? aws_cdk_lib_1.Names.nodeUniqueId(this.node).toLowerCase();
        this.resource = new aws_glue_1.CfnDatabase(this, 'Resource', {
            catalogId: this.stack.account,
            databaseInput: {
                description: this.description,
                locationUri: this.locationUri,
                name: this.name,
            },
        });
        this.catalogArn = this.stack.formatArn({
            resource: 'catalog',
            service: 'glue',
        });
        this.catalogId = this.stack.account;
        this.databaseArn = this.stack.formatArn({
            resource: 'database',
            resourceName: this.resource.ref,
            service: 'glue',
        });
        this.databaseName = this.resource.ref;
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "cdk-extensions.glue.Database", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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