"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcConnection = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
/**
 * Creates a Connection resource to a Java Database
 *
 * @see [AWS::Glue::Connection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html)
 */
class JdbcConnection extends _1.Connection {
    /**
   * Creates a new instance of the JdbcConnection class
   *
   * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
   */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            connectionType: _1.ConnectionType.JDBC,
            properties: {
                JDBC_CONNECTION_URL: props.url,
                JDBC_ENFORCE_SSL: `${props.enforceSsl ?? false}`,
                PASSWORD: props.password.toString(),
                USERNAME: props.username,
            },
        });
        this.password = props.password;
        this.url = props.url;
        this.username = props.username;
    }
}
exports.JdbcConnection = JdbcConnection;
_a = JSII_RTTI_SYMBOL_1;
JdbcConnection[_a] = { fqn: "cdk-extensions.glue.JdbcConnection", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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