"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StructColumn = exports.BasicColumn = exports.ArrayColumn = exports.Column = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class Column {
    constructor(props) {
        this.comment = props.comment;
        this.name = props.name;
    }
    bind(scope) {
        if (!this.name) {
            aws_cdk_lib_1.Annotations.of(scope).addError([
                'Names are required for all Glue Table columns that are not',
                'immediately inside an array',
            ].join(' '));
        }
        return {
            comment: this.comment,
            name: this.name ?? '<unknown>',
            type: this.typeString,
        };
    }
}
exports.Column = Column;
_a = JSII_RTTI_SYMBOL_1;
Column[_a] = { fqn: "cdk-extensions.glue.Column", version: "0.0.38" };
class ArrayColumn extends Column {
    constructor(props) {
        super(props);
        this.typeString = `array<${props.data.typeString}>`;
    }
}
exports.ArrayColumn = ArrayColumn;
_b = JSII_RTTI_SYMBOL_1;
ArrayColumn[_b] = { fqn: "cdk-extensions.glue.ArrayColumn", version: "0.0.38" };
class BasicColumn extends Column {
    constructor(props) {
        super(props);
        this.typeString = props.type;
    }
}
exports.BasicColumn = BasicColumn;
_c = JSII_RTTI_SYMBOL_1;
BasicColumn[_c] = { fqn: "cdk-extensions.glue.BasicColumn", version: "0.0.38" };
class StructColumn extends Column {
    constructor(props) {
        super(props);
        this._inner = [];
        this.typeString = aws_cdk_lib_1.Lazy.string({
            produce: () => {
                const innerTypes = this._inner.map((x) => {
                    if (!x.name) {
                        throw new Error([
                            'Names are required for all Glue Table columns',
                            'that are not immediately inside an array',
                        ].join(' '));
                    }
                    return `${x.name}:${x.typeString}`;
                }).join(',');
                return `struct<${innerTypes}>`;
            },
        });
        props.data?.forEach((x) => {
            this.addColumn(x);
        });
    }
    addColumn(column) {
        this._inner.push(column);
    }
}
exports.StructColumn = StructColumn;
_d = JSII_RTTI_SYMBOL_1;
StructColumn[_d] = { fqn: "cdk-extensions.glue.StructColumn", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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