"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The job type.
 *
 * If you need to use a JobType that doesn't exist as a static member, you
 * can instantiate a `JobType` object, e.g: `JobType.of('other name')`.
 */
class JobType {
    constructor(name) {
        this.name = name;
    }
    /**
       * Custom type name
       * @param name type name
       */
    static of(name) {
        return new JobType(name);
    }
}
exports.JobType = JobType;
_a = JSII_RTTI_SYMBOL_1;
JobType[_a] = { fqn: "cdk-extensions.glue.JobType", version: "0.0.38" };
/**
   * Command for running a Glue ETL job.
   */
JobType.ETL = new JobType('glueetl');
/**
   * Command for running a Glue streaming job.
   */
JobType.STREAMING = new JobType('gluestreaming');
/**
   * Command for running a Glue python shell job.
   */
JobType.PYTHON_SHELL = new JobType('pythonshell');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiam9iLXR5cGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZ2x1ZS9saWIvam9iLXR5cGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTs7Ozs7R0FLRztBQUNILE1BQWEsT0FBTztJQTZCbEIsWUFBb0IsSUFBWTtRQUM5QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNuQixDQUFDO0lBZkQ7OztTQUdLO0lBQ0UsTUFBTSxDQUFDLEVBQUUsQ0FBQyxJQUFZO1FBQzNCLE9BQU8sSUFBSSxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDM0IsQ0FBQzs7QUF0QkgsMEJBZ0NDOzs7QUEvQkM7O0tBRUs7QUFDa0IsV0FBRyxHQUFHLElBQUksT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBRXBEOztLQUVLO0FBQ2tCLGlCQUFTLEdBQUcsSUFBSSxPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7QUFFaEU7O0tBRUs7QUFDa0Isb0JBQVksR0FBRyxJQUFJLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVGhlIGpvYiB0eXBlLlxuICpcbiAqIElmIHlvdSBuZWVkIHRvIHVzZSBhIEpvYlR5cGUgdGhhdCBkb2Vzbid0IGV4aXN0IGFzIGEgc3RhdGljIG1lbWJlciwgeW91XG4gKiBjYW4gaW5zdGFudGlhdGUgYSBgSm9iVHlwZWAgb2JqZWN0LCBlLmc6IGBKb2JUeXBlLm9mKCdvdGhlciBuYW1lJylgLlxuICovXG5leHBvcnQgY2xhc3MgSm9iVHlwZSB7XG4gIC8qKlxuICAgICAqIENvbW1hbmQgZm9yIHJ1bm5pbmcgYSBHbHVlIEVUTCBqb2IuXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRVRMID0gbmV3IEpvYlR5cGUoJ2dsdWVldGwnKTtcblxuICAvKipcbiAgICAgKiBDb21tYW5kIGZvciBydW5uaW5nIGEgR2x1ZSBzdHJlYW1pbmcgam9iLlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNUUkVBTUlORyA9IG5ldyBKb2JUeXBlKCdnbHVlc3RyZWFtaW5nJyk7XG5cbiAgLyoqXG4gICAgICogQ29tbWFuZCBmb3IgcnVubmluZyBhIEdsdWUgcHl0aG9uIHNoZWxsIGpvYi5cbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQWVRIT05fU0hFTEwgPSBuZXcgSm9iVHlwZSgncHl0aG9uc2hlbGwnKTtcblxuICAvKipcbiAgICAgKiBDdXN0b20gdHlwZSBuYW1lXG4gICAgICogQHBhcmFtIG5hbWUgdHlwZSBuYW1lXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YobmFtZTogc3RyaW5nKTogSm9iVHlwZSB7XG4gICAgcmV0dXJuIG5ldyBKb2JUeXBlKG5hbWUpO1xuICB9XG5cbiAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhpcyBKb2JUeXBlLCBhcyBleHBlY3RlZCBieSBKb2IgcmVzb3VyY2UuXG4gICAgICovXG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihuYW1lOiBzdHJpbmcpIHtcbiAgICB0aGlzLm5hbWUgPSBuYW1lO1xuICB9XG59XG4iXX0=