"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class JdbcTarget {
    /**
       * Creates a new instance of the JdbcTarget class.
       *
       * @param scope A Connection Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(connection, options) {
        // Internal properties
        this._exclusions = [];
        this._paths = [];
        this.connection = connection;
        options.exclusions?.forEach((x) => {
            this.addExclusion(x);
        });
        options.paths?.forEach((x) => {
            this.addPath(x);
        });
    }
    addExclusion(exclusion) {
        this._exclusions.push(exclusion);
    }
    addPath(path) {
        this._paths.push(path);
    }
    bind(_crawler) {
        const paths = !!this._paths.length ? this._paths : [undefined];
        return {
            jdbcTargets: paths.map((x) => {
                return {
                    connectionName: this.connection.connectionName,
                    exclusions: aws_cdk_lib_1.Lazy.uncachedList({
                        produce: () => {
                            return this._exclusions;
                        },
                    }, {
                        omitEmpty: true,
                    }),
                    path: x,
                };
            }),
        };
    }
}
exports.JdbcTarget = JdbcTarget;
_a = JSII_RTTI_SYMBOL_1;
JdbcTarget[_a] = { fqn: "cdk-extensions.glue.JdbcTarget", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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