"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Target = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class S3Target {
    constructor(bucket, options) {
        // Internal properties
        this._exclusions = [];
        this.bucket = bucket;
        this.connection = options?.connection;
        this.keyPrefix = options?.keyPrefix;
        this.sampleSize = options?.sampleSize;
        options?.exclusions?.forEach((x) => {
            this.addExclusion(x);
        });
    }
    addExclusion(exclusion) {
        this._exclusions.push(exclusion);
    }
    bind(crawler) {
        crawler.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: [
                's3:GetObject',
                's3:PutObject',
            ],
            effect: aws_iam_1.Effect.ALLOW,
            resources: [
                this.bucket.arnForObjects(`${this.keyPrefix ?? ''}*`),
            ],
        }));
        return {
            s3Targets: [{
                    connectionName: this.connection?.connectionName,
                    exclusions: aws_cdk_lib_1.Lazy.uncachedList({
                        produce: () => {
                            return this._exclusions;
                        },
                    }, {
                        omitEmpty: true,
                    }),
                    path: `s3://${this.bucket.bucketName}/${this.keyPrefix ?? ''}`,
                }],
        };
    }
}
exports.S3Target = S3Target;
_a = JSII_RTTI_SYMBOL_1;
S3Target[_a] = { fqn: "cdk-extensions.glue.S3Target", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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