"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowActionBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const formatting_1 = require("../../../utils/formatting");
/**
 * Base class providing common functionality for workflow trigger actions.
 */
class WorkflowActionBase {
    /**
     * Creates a new instance of the WorkflowActionBase class.
     *
     * @param options Options controlling aspects of the action being executed.
     */
    constructor(options) {
        /**
         * Internal list of arguments that will be passed to the Glue job when run as
         * part of the workflow.
         */
        this._arguments = {};
        this.notifyDelayAfter = options?.notifyDelayAfter;
        this.securityConfiguration = options?.securityConfiguration;
        this.timeout = options?.timeout;
        const args = options?.arguments ?? {};
        Object.keys(args).forEach((x) => {
            this.addArgument(x, args[x]);
        });
    }
    /**
     * Adds an argument that will be passed to the specified action when
     * triggered as part of a workflow.
     *
     * @see [AWS Glue job parameters](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
     *
     * @param key The name of the argument being set.
     * @param value The value to pass for the specified argument.
     */
    addArgument(key, value) {
        this._arguments[key] = value;
    }
    /**
     * Associates the action with a construct that is configuring a trigger for a
     * Glue workflow.
     *
     * @param _scope The construct configuring the Glue trigger.
     * @returns A configuration object that can be used to configure a triggered
     * workflow action.
     */
    bindOptions(_scope) {
        return {
            arguments: aws_cdk_lib_1.Lazy.uncachedAny({
                produce: () => {
                    return !!Object.keys(this._arguments).length ? this._arguments : undefined;
                },
            }),
            notificationProperty: formatting_1.undefinedIfNoKeys({
                notifyDelayAfter: this.notifyDelayAfter?.toMinutes(),
            }),
            securityConfiguration: this.securityConfiguration,
            timeout: this.timeout?.toMinutes(),
        };
    }
}
exports.WorkflowActionBase = WorkflowActionBase;
_a = JSII_RTTI_SYMBOL_1;
WorkflowActionBase[_a] = { fqn: "cdk-extensions.glue.WorkflowActionBase", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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