"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowAction = void 0;
const _1 = require(".");
/**
 * Actions to be started by a Glue workflow trigger when it is activated.
 */
class WorkflowAction {
    /**
     * An action that runs a crawler as part of a Glue workflow.
     *
     * @param crawler The crawler to run as part of the workflow.
     * @param options The options configuring how the crawler should be run.
     * @returns A workflow action that runs the crawler with the given options.
     */
    static crawler(crawler, options) {
        return new _1.WorkflowCrawlerAction(crawler, options);
    }
    /**
     * An action that runs a Glue job as part of a workflow.
     *
     * @param job The job to run as part of the workflow.
     * @param options The options configuring how the job should be run.
     * @returns A workflow action that runs the job with the given options.
     */
    static job(job, options) {
        return new _1.WorkflowJobAction(job, options);
    }
}
exports.WorkflowAction = WorkflowAction;
//# sourceMappingURL=data:application/json;base64,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