"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowCrawlerAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const action_base_1 = require("./action-base");
/**
 * Configuration options for the WorkflowCrawlerAction class.
 */
class WorkflowCrawlerAction extends action_base_1.WorkflowActionBase {
    /**
     * Creates a new instance of the WorkflowCrawlerAction class.
     *
     * @param crawler The crawler that should be triggered as part of the
     * workflow.
     * @param options The options affecting how the crawler should be triggered.
     */
    constructor(crawler, options) {
        super(options);
        this.crawler = crawler;
    }
    /**
     * Associates this action with a resource that is configuring a Glue trigger.
     *
     * @param scope The construct configuring the trigger that this action will
     * be used in.
     * @returns The configuration that can be used to configure the underlying
     * trigger resource.
     */
    bind(scope) {
        return {
            ...super.bindOptions(scope),
            crawlerName: this.crawler.crawlerName,
        };
    }
}
exports.WorkflowCrawlerAction = WorkflowCrawlerAction;
_a = JSII_RTTI_SYMBOL_1;
WorkflowCrawlerAction[_a] = { fqn: "cdk-extensions.glue.WorkflowCrawlerAction", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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