"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowJobAction = exports.BookmarkConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const action_base_1 = require("./action-base");
/**
 * Controls the bookmark state of a Glue job.
 *
 * @see [Using job bookmarks in AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-continuations.html#monitor-continuations-implement)
 */
class BookmarkConfiguration {
    /**
     * Creates a new instance of the BookmarkConfiguration class.
     *
     * @param value The value to pass to the `job-bookmark-option` argument.
     * @param range An optional range of job ID's that will correspond to the
     * `job-bookmark-from` and `job-bookmark-to` arguments.
     */
    constructor(value, range) {
        this.value = value;
        this.range = range;
    }
    /**
     * Job bookmarks are not used, and the job always processes the entire
     * dataset. You are responsible for managing the output from previous job
     * runs.
     *
     * @returns A configuration object that disabled job bookmarks.
     */
    static disable() {
        return BookmarkConfiguration.of('job-bookmark-disable');
    }
    /**
     * Causes the job to update the state after a run to keep track of previously
     * processed data. If your job has a source with job bookmark support, it
     * will keep track of processed data, and when a job runs, it processes new
     * data since the last checkpoint.
     *
     * @returns A configuration object that enables job bookmarks.
     */
    static enable() {
        return BookmarkConfiguration.of('job-bookmark-enable');
    }
    /**
     * Process incremental data since the last successful run or the data in a
     * specified range, without updating the state of last bookmark. You are
     * responsible for managing the output from previous job runs.
     *
     * @param range The range of run ID's that should have their data processed.
     * @returns A configuration object that pauses job bookmarks.
     */
    static pause(range) {
        return BookmarkConfiguration.of('job-bookmark-pause', range);
    }
    /**
     * An escape hatch method that allows specifying arbitrary values for the
     * `job-bookmark-option` argument of a Glue job.
     *
     * @param value The value to pass to the `job-bookmark-option` argument.
     * @param range An optional range of job ID's that will correspond to the
     * `job-bookmark-from` and `job-bookmark-to` arguments.
     * @returns A configuration object that represents the provided bookmark configuration.
     */
    static of(value, range) {
        return new BookmarkConfiguration(value, range);
    }
}
exports.BookmarkConfiguration = BookmarkConfiguration;
_a = JSII_RTTI_SYMBOL_1;
BookmarkConfiguration[_a] = { fqn: "cdk-extensions.glue.BookmarkConfiguration", version: "0.0.38" };
/**
 * Represents the configuration for a job that will be triggered as part of a
 * workflow.
 */
class WorkflowJobAction extends action_base_1.WorkflowActionBase {
    /**
     * Creates a new instance of the WorkflowJobAction class.
     *
     * @param job The job that should be triggered as part of the workflow.
     * @param options The options affecting how the job should be triggered.
     */
    constructor(job, options) {
        super(options);
        this.job = job;
        if (options?.bookmarkConfiguration) {
            this.addArgument('--job-bookmark-option', options.bookmarkConfiguration.value);
            if (options.bookmarkConfiguration.range) {
                this.addArgument('--job-bookmark-from', options.bookmarkConfiguration.range.from);
                this.addArgument('--job-bookmark-to', options.bookmarkConfiguration.range.to);
            }
        }
    }
    /**
     * Associates this action with a resource that is configuring a Glue trigger.
     *
     * @param scope The construct configuring the trigger that this action will
     * be used in.
     * @returns The configuration that can be used to configure the underlying
     * trigger resource.
     */
    bind(scope) {
        return {
            ...super.bindOptions(scope),
            jobName: this.job.jobName,
        };
    }
}
exports.WorkflowJobAction = WorkflowJobAction;
_b = JSII_RTTI_SYMBOL_1;
WorkflowJobAction[_b] = { fqn: "cdk-extensions.glue.WorkflowJobAction", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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