"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowCrawlerPredicate = exports.CrawlerState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const predicate_base_1 = require("./predicate-base");
/**
 * State a Glue crawler must be in in order to satisfy a predicate condition to
 * trigger a part of a workflow.
 */
var CrawlerState;
(function (CrawlerState) {
    /**
     * A crawler execution was cancelled before it could finish.
     */
    CrawlerState["CANCELLED"] = "CANCELLED";
    /**
     * A crawler that has finished and ended in an error.
     */
    CrawlerState["FAILED"] = "FAILED";
    /**
     * A crawler which has finished successfully.
     */
    CrawlerState["SUCCEEDED"] = "SUCCEEDED";
})(CrawlerState = exports.CrawlerState || (exports.CrawlerState = {}));
/**
 * Represents a condition that is predicated on a Glue crawler completion.
 *
 * The condition can be used to create a trigger that controls the execution of
 * downstream tasks in a workflow.
 */
class WorkflowCrawlerPredicate extends predicate_base_1.WorkflowPredicateBase {
    /**
     * Creates a new instance of the WorkflowCrawlerPredicate class.
     *
     * @param crawler The crawler which must complete in order to meet the
     * requirements to trigger the next stage of the workflow.
     * @param options Options specifying the conditions the crawler must meet to
     * trigger the next stage of the workflow.
     */
    constructor(crawler, options) {
        super(options);
        this.crawler = crawler;
        this.logicalOperator = options?.logicalOperator ?? predicate_base_1.PredicateLogicalOperator.EQUALS;
        this.state = options?.state ?? CrawlerState.SUCCEEDED;
    }
    /**
     * Associates the predicate with a construct that is configuring a trigger
     * for a Glue workflow.
     *
     * @param scope The construct configuring the Glue trigger.
     * @returns A configuration object that can be used to configure a predicate
     * condition for the Glue trigger.
     */
    bind(scope) {
        return {
            ...super.bindOptions(scope),
            crawlerName: this.crawler.crawlerName,
            crawlState: this.state,
            logicalOperator: this.logicalOperator,
        };
    }
}
exports.WorkflowCrawlerPredicate = WorkflowCrawlerPredicate;
_a = JSII_RTTI_SYMBOL_1;
WorkflowCrawlerPredicate[_a] = { fqn: "cdk-extensions.glue.WorkflowCrawlerPredicate", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3Jhd2xlci1wcmVkaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvZ2x1ZS9saWIvd29ya2Zsb3ctcHJlZGljYXRlcy9jcmF3bGVyLXByZWRpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLHFEQUE2RztBQUc3Rzs7O0dBR0c7QUFDSCxJQUFZLFlBZVg7QUFmRCxXQUFZLFlBQVk7SUFDdEI7O09BRUc7SUFDSCx1Q0FBdUIsQ0FBQTtJQUV2Qjs7T0FFRztJQUNILGlDQUFpQixDQUFBO0lBRWpCOztPQUVHO0lBQ0gsdUNBQXVCLENBQUE7QUFDekIsQ0FBQyxFQWZXLFlBQVksR0FBWixvQkFBWSxLQUFaLG9CQUFZLFFBZXZCO0FBMEJEOzs7OztHQUtHO0FBQ0gsTUFBYSx3QkFBeUIsU0FBUSxzQ0FBcUI7SUE4QmpFOzs7Ozs7O09BT0c7SUFDSCxZQUFtQixPQUFpQixFQUFFLE9BQXlDO1FBQzdFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVmLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsT0FBTyxFQUFFLGVBQWUsSUFBSSx5Q0FBd0IsQ0FBQyxNQUFNLENBQUM7UUFDbkYsSUFBSSxDQUFDLEtBQUssR0FBRyxPQUFPLEVBQUUsS0FBSyxJQUFJLFlBQVksQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVEOzs7Ozs7O09BT0c7SUFDSSxJQUFJLENBQUMsS0FBaUI7UUFDM0IsT0FBTztZQUNMLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUM7WUFDM0IsV0FBVyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVztZQUNyQyxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDdEIsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1NBQ3RDLENBQUM7SUFDSixDQUFDOztBQTdESCw0REE4REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5UcmlnZ2VyIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWdsdWUnO1xuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUNyYXdsZXIsIElUcmlnZ2VyUHJlZGljYXRlIH0gZnJvbSAnLi4vLi4nO1xuaW1wb3J0IHsgV29ya2Zsb3dQcmVkaWNhdGVCYXNlLCBQcmVkaWNhdGVMb2dpY2FsT3BlcmF0b3IsIFdvcmtmbG93UHJlZGljYXRlT3B0aW9ucyB9IGZyb20gJy4vcHJlZGljYXRlLWJhc2UnO1xuXG5cbi8qKlxuICogU3RhdGUgYSBHbHVlIGNyYXdsZXIgbXVzdCBiZSBpbiBpbiBvcmRlciB0byBzYXRpc2Z5IGEgcHJlZGljYXRlIGNvbmRpdGlvbiB0b1xuICogdHJpZ2dlciBhIHBhcnQgb2YgYSB3b3JrZmxvdy5cbiAqL1xuZXhwb3J0IGVudW0gQ3Jhd2xlclN0YXRlIHtcbiAgLyoqXG4gICAqIEEgY3Jhd2xlciBleGVjdXRpb24gd2FzIGNhbmNlbGxlZCBiZWZvcmUgaXQgY291bGQgZmluaXNoLlxuICAgKi9cbiAgQ0FOQ0VMTEVEID0gJ0NBTkNFTExFRCcsXG5cbiAgLyoqXG4gICAqIEEgY3Jhd2xlciB0aGF0IGhhcyBmaW5pc2hlZCBhbmQgZW5kZWQgaW4gYW4gZXJyb3IuXG4gICAqL1xuICBGQUlMRUQgPSAnRkFJTEVEJyxcblxuICAvKipcbiAgICogQSBjcmF3bGVyIHdoaWNoIGhhcyBmaW5pc2hlZCBzdWNjZXNzZnVsbHkuXG4gICAqL1xuICBTVUNDRUVERUQgPSAnU1VDQ0VFREVEJ1xufVxuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gb3B0aW9ucyB0aGF0IHNwZWNpZnkgdGhlIHN0YXRlIGEgY3Jhd2xlciBtdXN0IG1lZXQgaW4gb3JkZXIgdG9cbiAqIHNhdGlzZnkgdGhlIGNvbmRpdGlvbnMgb2YgdGhlIHByZWRpY2F0ZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBXb3JrZmxvd0NyYXdsZXJQcmVkaWNhdGVPcHRpb25zIGV4dGVuZHMgV29ya2Zsb3dQcmVkaWNhdGVPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBsb2dpY2FsIG9wZXJhdG9yIHdoaWNoIHNob3VsZCBiZSBhcHBsaWVkIGluIGRldGVybWluaW5nIHdoZXRoZXIgYVxuICAgKiBjcmF3bGVyIG1lZXRzIHRoZSByZXF1ZXN0ZWQgY29uZGl0aW9ucy5cbiAgICpcbiAgICogQXQgdGhlIG1vbWVudCwgdGhlIG9ubHkgc3VwcG9ydGVkIG9wZXJhdG9yIGlzIGBFUVVBTFNgLlxuICAgKlxuICAgKiBAc2VlIFtUcmlnZ2VyIFByZWRpY2F0ZS5Db25kaXRpb25zLkxvZ2ljYWxPcGVyYXRvcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2x1ZS10cmlnZ2VyLWNvbmRpdGlvbi5odG1sI2Nmbi1nbHVlLXRyaWdnZXItY29uZGl0aW9uLWxvZ2ljYWxvcGVyYXRvcilcbiAgICovXG4gIHJlYWRvbmx5IGxvZ2ljYWxPcGVyYXRvcjogUHJlZGljYXRlTG9naWNhbE9wZXJhdG9yO1xuXG4gIC8qKlxuICAgKiBUaGUgc3RhdGUgdGhhdCB0aGUgY3Jhd2xlciBtdXN0IGJlIGluIGluIG9yZGVyIHRvIG1lZXQgdGhlIGNyaXRlcmlhIHRvXG4gICAqIHRyaWdnZXIgdGhlIG5leHQgc3RhZ2Ugb2YgdGhlIHdvcmtmbG93LlxuICAgKlxuICAgKiBAc2VlIFtUcmlnZ2VyIFByZWRpY2F0ZS5Db25kaXRpb25zLkNyYXdsU3RhdGVdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWdsdWUtdHJpZ2dlci1jb25kaXRpb24uaHRtbCNjZm4tZ2x1ZS10cmlnZ2VyLWNvbmRpdGlvbi1jcmF3bHN0YXRlKVxuICAgKi9cbiAgcmVhZG9ubHkgc3RhdGU/OiBDcmF3bGVyU3RhdGU7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGNvbmRpdGlvbiB0aGF0IGlzIHByZWRpY2F0ZWQgb24gYSBHbHVlIGNyYXdsZXIgY29tcGxldGlvbi5cbiAqXG4gKiBUaGUgY29uZGl0aW9uIGNhbiBiZSB1c2VkIHRvIGNyZWF0ZSBhIHRyaWdnZXIgdGhhdCBjb250cm9scyB0aGUgZXhlY3V0aW9uIG9mXG4gKiBkb3duc3RyZWFtIHRhc2tzIGluIGEgd29ya2Zsb3cuXG4gKi9cbmV4cG9ydCBjbGFzcyBXb3JrZmxvd0NyYXdsZXJQcmVkaWNhdGUgZXh0ZW5kcyBXb3JrZmxvd1ByZWRpY2F0ZUJhc2UgaW1wbGVtZW50cyBJVHJpZ2dlclByZWRpY2F0ZSB7XG4gIC8qKlxuICAgKiBUaGUgY3Jhd2xlciB3aGljaCBtdXN0IGNvbXBsZXRlIGluIG9yZGVyIHRvIG1lZXQgdGhlIHJlcXVpcmVtZW50cyB0b1xuICAgKiB0cmlnZ2VyIHRoZSBuZXh0IHN0YWdlIG9mIHRoZSB3b3JrZmxvdy5cbiAgICpcbiAgICogQHNlZSBbVHJpZ2dlciBQcmVkaWNhdGUuQ29uZGl0aW9ucy5DcmF3bGVyTmFtZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2x1ZS10cmlnZ2VyLWNvbmRpdGlvbi5odG1sI2Nmbi1nbHVlLXRyaWdnZXItY29uZGl0aW9uLWNyYXdsZXJuYW1lKVxuICAgKlxuICAgKiBAZ3JvdXAgSW5wdXRzXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY3Jhd2xlcjogSUNyYXdsZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBsb2dpY2FsIG9wZXJhdG9yIHdoaWNoIHNob3VsZCBiZSBhcHBsaWVkIGluIGRldGVybWluaW5nIHdoZXRoZXIgYVxuICAgKiBjcmF3bGVyIG1lZXRzIHRoZSByZXF1ZXN0ZWQgY29uZGl0aW9ucy5cbiAgICpcbiAgICogQXQgdGhlIG1vbWVudCwgdGhlIG9ubHkgc3VwcG9ydGVkIG9wZXJhdG9yIGlzIGBFUVVBTFNgLlxuICAgKlxuICAgKiBAc2VlIFtUcmlnZ2VyIFByZWRpY2F0ZS5Db25kaXRpb25zLkxvZ2ljYWxPcGVyYXRvcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZ2x1ZS10cmlnZ2VyLWNvbmRpdGlvbi5odG1sI2Nmbi1nbHVlLXRyaWdnZXItY29uZGl0aW9uLWxvZ2ljYWxvcGVyYXRvcilcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBsb2dpY2FsT3BlcmF0b3I6IFByZWRpY2F0ZUxvZ2ljYWxPcGVyYXRvcjtcblxuICAvKipcbiAgICogVGhlIHN0YXRlIHRoYXQgdGhlIGNyYXdsZXIgbXVzdCBiZSBpbiBpbiBvcmRlciB0byBtZWV0IHRoZSBjcml0ZXJpYSB0b1xuICAgKiB0cmlnZ2VyIHRoZSBuZXh0IHN0YWdlIG9mIHRoZSB3b3JrZmxvdy5cbiAgICpcbiAgICogQHNlZSBbVHJpZ2dlciBQcmVkaWNhdGUuQ29uZGl0aW9ucy5DcmF3bFN0YXRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1nbHVlLXRyaWdnZXItY29uZGl0aW9uLmh0bWwjY2ZuLWdsdWUtdHJpZ2dlci1jb25kaXRpb24tY3Jhd2xzdGF0ZSlcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzdGF0ZTogQ3Jhd2xlclN0YXRlO1xuXG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIFdvcmtmbG93Q3Jhd2xlclByZWRpY2F0ZSBjbGFzcy5cbiAgICpcbiAgICogQHBhcmFtIGNyYXdsZXIgVGhlIGNyYXdsZXIgd2hpY2ggbXVzdCBjb21wbGV0ZSBpbiBvcmRlciB0byBtZWV0IHRoZVxuICAgKiByZXF1aXJlbWVudHMgdG8gdHJpZ2dlciB0aGUgbmV4dCBzdGFnZSBvZiB0aGUgd29ya2Zsb3cuXG4gICAqIEBwYXJhbSBvcHRpb25zIE9wdGlvbnMgc3BlY2lmeWluZyB0aGUgY29uZGl0aW9ucyB0aGUgY3Jhd2xlciBtdXN0IG1lZXQgdG9cbiAgICogdHJpZ2dlciB0aGUgbmV4dCBzdGFnZSBvZiB0aGUgd29ya2Zsb3cuXG4gICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IoY3Jhd2xlcjogSUNyYXdsZXIsIG9wdGlvbnM/OiBXb3JrZmxvd0NyYXdsZXJQcmVkaWNhdGVPcHRpb25zKSB7XG4gICAgc3VwZXIob3B0aW9ucyk7XG5cbiAgICB0aGlzLmNyYXdsZXIgPSBjcmF3bGVyO1xuICAgIHRoaXMubG9naWNhbE9wZXJhdG9yID0gb3B0aW9ucz8ubG9naWNhbE9wZXJhdG9yID8/IFByZWRpY2F0ZUxvZ2ljYWxPcGVyYXRvci5FUVVBTFM7XG4gICAgdGhpcy5zdGF0ZSA9IG9wdGlvbnM/LnN0YXRlID8/IENyYXdsZXJTdGF0ZS5TVUNDRUVERUQ7XG4gIH1cblxuICAvKipcbiAgICogQXNzb2NpYXRlcyB0aGUgcHJlZGljYXRlIHdpdGggYSBjb25zdHJ1Y3QgdGhhdCBpcyBjb25maWd1cmluZyBhIHRyaWdnZXJcbiAgICogZm9yIGEgR2x1ZSB3b3JrZmxvdy5cbiAgICpcbiAgICogQHBhcmFtIHNjb3BlIFRoZSBjb25zdHJ1Y3QgY29uZmlndXJpbmcgdGhlIEdsdWUgdHJpZ2dlci5cbiAgICogQHJldHVybnMgQSBjb25maWd1cmF0aW9uIG9iamVjdCB0aGF0IGNhbiBiZSB1c2VkIHRvIGNvbmZpZ3VyZSBhIHByZWRpY2F0ZVxuICAgKiBjb25kaXRpb24gZm9yIHRoZSBHbHVlIHRyaWdnZXIuXG4gICAqL1xuICBwdWJsaWMgYmluZChzY29wZTogSUNvbnN0cnVjdCk6IENmblRyaWdnZXIuQ29uZGl0aW9uUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5zdXBlci5iaW5kT3B0aW9ucyhzY29wZSksXG4gICAgICBjcmF3bGVyTmFtZTogdGhpcy5jcmF3bGVyLmNyYXdsZXJOYW1lLFxuICAgICAgY3Jhd2xTdGF0ZTogdGhpcy5zdGF0ZSxcbiAgICAgIGxvZ2ljYWxPcGVyYXRvcjogdGhpcy5sb2dpY2FsT3BlcmF0b3IsXG4gICAgfTtcbiAgfVxufSJdfQ==