"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowJobPredicate = exports.JobState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const predicate_base_1 = require("./predicate-base");
/**
 * State a Glue job must be in in order to satisfy a predicate condition to
 * trigger a part of a workflow.
 */
var JobState;
(function (JobState) {
    /**
     * A job that has finished and ended with an error.
     */
    JobState["FAILED"] = "FAILED";
    /**
     * A job which was stopped before completion.
     */
    JobState["STOPPED"] = "STOPPED";
    /**
     * A job which has finished successfully.
     */
    JobState["SUCCEEDED"] = "SUCCEEDED";
    /**
     * A job which timed out without completing.
     */
    JobState["TIMEOUT"] = "TIMEOUT";
})(JobState = exports.JobState || (exports.JobState = {}));
/**
 * Represents a condition that is predicated on a Glue job completion.
 *
 * The condition can be used to create a trigger that controls the execution of
 * downstream tasks in a workflow.
 */
class WorkflowJobPredicate extends predicate_base_1.WorkflowPredicateBase {
    /**
     * Creates a new instance of the WorkflowJobPredicate class.
     *
     * @param job The job which must complete in order to meet the requirements
     * to trigger the next stage of the workflow.
     * @param options Options specifying the conditions the job must meet to
     * trigger the next stage of the workflow.
     */
    constructor(job, options) {
        super(options);
        this.job = job;
        this.logicalOperator = options?.logicalOperator ?? predicate_base_1.PredicateLogicalOperator.EQUALS;
        this.state = options?.state ?? JobState.SUCCEEDED;
    }
    /**
     * Associates the predicate with a construct that is configuring a trigger
     * for a Glue workflow.
     *
     * @param scope The construct configuring the Glue trigger.
     * @returns A configuration object that can be used to configure a predicate
     * condition for the Glue trigger.
     */
    bind(scope) {
        return {
            ...super.bindOptions(scope),
            jobName: this.job.jobName,
            logicalOperator: this.logicalOperator,
            state: this.state,
        };
    }
}
exports.WorkflowJobPredicate = WorkflowJobPredicate;
_a = JSII_RTTI_SYMBOL_1;
WorkflowJobPredicate[_a] = { fqn: "cdk-extensions.glue.WorkflowJobPredicate", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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