"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowPredicateBase = exports.PredicateLogicalOperator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Logical operator that specifies how the conditions of a predicate should be
 * evaluated.
 */
var PredicateLogicalOperator;
(function (PredicateLogicalOperator) {
    /**
     * State equals specified value.
     */
    PredicateLogicalOperator["EQUALS"] = "EQUALS";
})(PredicateLogicalOperator = exports.PredicateLogicalOperator || (exports.PredicateLogicalOperator = {}));
/**
 * Base class providing common functionality for trigger predicate conditions.
 */
class WorkflowPredicateBase {
    /**
     * Create a new instance of the WorkflowPredicateBase class.
     *
     * @param _options Options specifying the conditions the predicate must meet
     * to trigger the next stage of the workflow.
     */
    constructor(_options) { }
    /**
     * Associates the predicate with a construct that is configuring a trigger
     * for a Glue workflow.
     *
     * @param _scope The construct configuring the Glue trigger.
     * @returns A configuration object that can be used to configure a predicate
     * condition for the Glue trigger.
     */
    bindOptions(_scope) {
        return {};
    }
}
exports.WorkflowPredicateBase = WorkflowPredicateBase;
_a = JSII_RTTI_SYMBOL_1;
WorkflowPredicateBase[_a] = { fqn: "cdk-extensions.glue.WorkflowPredicateBase", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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