"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowPredicate = void 0;
const _1 = require(".");
/**
 * Predicate conditions for controlling trigger activation in a Glue workflow.
 */
class WorkflowPredicate {
    /**
     * A predicate condition dependent on the completion of a Glue crawler.
     *
     * @param crawler The crawler which must complete in order to meet the
     * requirements to trigger the next stage of the workflow.
     * @param options Options specifying the conditions the crawler must meet to
     * trigger the next stage of the workflow.
     * @returns A workflow condition that is predicated on the completion of the
     * specified Glue crawler.
     */
    static crawler(crawler, options) {
        return new _1.WorkflowCrawlerPredicate(crawler, options);
    }
    /**
     * A predicate condition dependent on the completion of a Glue job.
     *
     * @param job The job which must complete in order to meet the requirements
     * to trigger the next stage of the workflow.
     * @param options Options specifying the conditions the job must meet to
     * trigger the next stage of the workflow.
     * @returns A workflow condition that is predicated on the completion of the
     * specified Glue crawler.
     */
    static job(job, options) {
        return new _1.WorkflowJobPredicate(job, options);
    }
}
exports.WorkflowPredicate = WorkflowPredicate;
//# sourceMappingURL=data:application/json;base64,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