"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
const formatting_1 = require("../utils/formatting");
var TableType;
(function (TableType) {
    TableType["EXTERNAL_TABLE"] = "EXTERNAL_TABLE";
    TableType["VIRTUAL_VIEW"] = "VIRTUAL_VIEW";
})(TableType = exports.TableType || (exports.TableType = {}));
/**
 * Creates a Table resource specifying tabular data in the Glue Database
 *
 * @see [AWS::Glue::Table](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html)
 */
class Table extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the Table class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._columns = [];
        this._parameters = {};
        this._partitionKeys = [];
        this._serdeParameters = {};
        this._storageParameters = {};
        this.compressed = props.compressed;
        this.database = props.database;
        this.dataFormat = props.dataFormat;
        this.description = props.description;
        this.location = props.location;
        this.name = props.name;
        this.owner = props.owner;
        this.retention = props.retention;
        this.serdeName = props.serdeName;
        this.tableType = props.tableType;
        this.viewExpandedText = props.viewExpandedText;
        this.viewOriginalText = props.viewOriginalText;
        this.storedAsSubDirectories = props.storedAsSubDirectories;
        Object.keys(props.parameters ?? {}).forEach((x) => {
            this.addParameter(x, props.parameters[x]);
        });
        Object.keys(props.serdeParameters ?? {}).forEach((x) => {
            this.addSerdeParameter(x, props.serdeParameters[x]);
        });
        Object.keys(props.storageParameters ?? {}).forEach((x) => {
            this.addStorageParameter(x, props.storageParameters[x]);
        });
        props.columns?.forEach((x) => {
            this.addColumn(x);
        });
        props.partitionKeys?.forEach((x) => {
            this.addPartitionKey(x);
        });
        this.resource = new aws_glue_1.CfnTable(this, 'Resource', {
            catalogId: this.stack.account,
            databaseName: this.database.databaseName,
            tableInput: {
                description: this.description,
                name: this.name,
                owner: this.owner,
                parameters: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return !!Object.keys(this._parameters).length ? this._parameters : [];
                    },
                }, {
                    omitEmptyArray: true,
                }),
                partitionKeys: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return this._partitionKeys.map((x) => {
                            return x.bind(this);
                        });
                    },
                }, {
                    omitEmptyArray: true,
                }),
                retention: this.retention?.toSeconds(),
                storageDescriptor: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return this.renderStorageDescriptor();
                    },
                }),
                tableType: this.tableType,
                targetTable: !!!this.targetTable ? undefined : {
                    catalogId: this.targetTable.database.catalogId,
                    databaseName: this.targetTable.database.databaseName,
                    name: this.targetTable.tableName,
                },
                viewExpandedText: this.viewExpandedText,
                viewOriginalText: this.viewOriginalText,
            },
        });
        this.tableArn = this.stack.formatArn({
            resource: 'table',
            resourceName: `${this.database.databaseName}/${this.resource.ref}`,
            service: 'glue',
        });
        this.tableName = this.resource.ref;
    }
    addColumn(column) {
        this._columns.push(column);
    }
    addParameter(key, value) {
        this._parameters[key] = value;
    }
    addPartitionKey(column) {
        this._partitionKeys.push(column);
    }
    addSerdeParameter(key, value) {
        this._serdeParameters[key] = value;
    }
    addStorageParameter(key, value) {
        this._storageParameters[key] = value;
    }
    renderStorageDescriptor() {
        return formatting_1.undefinedIfNoKeys({
            columns: !!!this._columns.length ? undefined : this._columns.map((x) => {
                return x.bind(this);
            }),
            compressed: this.compressed,
            inputFormat: this.dataFormat?.inputFormat.className,
            location: this.location,
            outputFormat: this.dataFormat?.outputFormat.className,
            parameters: !!!Object.keys(this._storageParameters).length ? undefined : this._storageParameters,
            serdeInfo: formatting_1.undefinedIfNoKeys({
                name: this.serdeName,
                parameters: formatting_1.undefinedIfNoKeys(this._serdeParameters),
                serializationLibrary: this.dataFormat?.serializationLibrary.className,
            }),
            storedAsSubDirectories: this.storedAsSubDirectories,
        });
    }
}
exports.Table = Table;
_a = JSII_RTTI_SYMBOL_1;
Table[_a] = { fqn: "cdk-extensions.glue.Table", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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