import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { CfnWorkflow } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
import { ITrigger } from '.';
import { ITriggerAction, ITriggerPredicate, PredicateOperator, TriggerType } from './trigger';
export interface TriggerOptions extends ResourceProps {
    readonly actions?: ITriggerAction[];
    readonly description?: string;
    readonly name?: string;
    readonly predicateConditions?: ITriggerPredicate[];
    readonly predicateOperator?: PredicateOperator;
    readonly schedule?: Schedule;
    readonly startOnCreation?: boolean;
    readonly type: TriggerType;
}
/**
 * Configuration for the Glue Workflow resource.
 */
export interface WorkflowProps extends ResourceProps {
    /**
     * A description of the Workflow
     */
    readonly description?: string;
    /**
     * A name of the Workflow
     */
    readonly name?: string;
}
export declare class Workflow extends Resource {
    /**
     * {@link WorkflowProps.description}
     */
    readonly description?: string;
    /**
     * {@link WorkflowProps.name}
     */
    readonly name?: string;
    readonly resource: CfnWorkflow;
    readonly workflowArn: string;
    readonly workflowName: string;
    /**
     * Creates a new instance of the Workflow class.
     *
     * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
     * @param id A name to be associated with the stack and used in resource naming. Must be unique
     * within the context of 'scope'.
     * @param props Arguments related to the configuration of the resource.
     */
    constructor(scope: Construct, id: string, props: WorkflowProps);
    addTrigger(id: string, options: TriggerOptions): ITrigger;
}
