"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
const trigger_1 = require("./trigger");
class Workflow extends aws_cdk_lib_1.Resource {
    /**
     * Creates a new instance of the Workflow class.
     *
     * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
     * @param id A name to be associated with the stack and used in resource naming. Must be unique
     * within the context of 'scope'.
     * @param props Arguments related to the configuration of the resource.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.description = props.description;
        this.name = props.name;
        this.resource = new aws_glue_1.CfnWorkflow(this, 'Resource', {
            description: this.description,
            name: this.name,
        });
        this.workflowArn = this.stack.formatArn({
            resource: 'table',
            resourceName: this.resource.ref,
            service: 'glue',
        });
        this.workflowName = this.resource.ref;
    }
    addTrigger(id, options) {
        return new trigger_1.Trigger(this, `trigger-${id}`, {
            ...options,
            workflow: this,
        });
    }
}
exports.Workflow = Workflow;
_a = JSII_RTTI_SYMBOL_1;
Workflow[_a] = { fqn: "cdk-extensions.glue.Workflow", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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