import { Resource, ResourceProps } from 'aws-cdk-lib';
import { ICluster, KubernetesManifest, ServiceAccount } from 'aws-cdk-lib/aws-eks';
import { Construct } from 'constructs';
/**
 * Condifuration for the AdorCollector resource.
 */
export interface AdotCollectorProps extends ResourceProps {
    /**
     * The EKS cluster where the ADOT Collector will be deployed.
     */
    readonly cluster: ICluster;
    /**
     * Flag wich sets whether the deploy of the ADOT collector should include
     * creating the Kubernetes namespace the service will be deployed to.
     *
     * @default true
     */
    readonly createNamespace?: boolean;
    /**
     * The Kubernetes namespace where resources related to the ADOT collector
     * will be created.
     *
     * @default {@link AdotCollector.DEFAULT_NAMESPACE}
     */
    readonly namespace?: string;
}
export declare class AdotCollector extends Resource {
    /**
     * The default Kubernetes namespace where resources related to the ADOT
     * collector will be created if no overriding input is provided.
     */
    static readonly DEFAULT_NAMESPACE: string;
    /**
     * The EKS cluster where the ADOT Collector will be deployed.
     *
     * @group Inputs
     */
    readonly cluster: ICluster;
    /**
     * Flag wich sets whether the deploy of the ADOT collector should include
     * creating the Kubernetes namespace the service will be deployed to.
     *
     * @group Inputs
     */
    readonly createNamespace: boolean;
    /**
     * The Kubernetes namespace where resources related to the ADOT collector
     * will be created.
     *
     * @group Inputs
     */
    readonly namespace: string;
    /**
     * The Kubernetes manifest used to deploy the ADOT Collector.
     *
     * @group Resources
     */
    readonly manifest: KubernetesManifest;
    /**
     * The Kubernetes service account that allows the ADOT collector to gather
     * metric information and publish it to CloudWatch.
     *
     * @group Resources
     */
    readonly serviceAccount: ServiceAccount;
    /**
     * Creates a new instance of the AdotCollector class.
     *
     * @param scope A CDK Construct that will serve as this resource's parent
     * in the construct tree.
     * @param id A name to be associated with the resource and used in resource
     * naming. Must be unique within the context of 'scope'.
     * @param props Arguments related to the configuration of the resource.
     */
    constructor(scope: Construct, id: string, props: AdotCollectorProps);
}
