"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsSecretStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
/**
 * A generic class representing secret store that is backed by an AWS service.
 */
class AwsSecretStore extends aws_cdk_lib_1.Resource {
    /**
     * Creates a new instance of the AwsSecretStore class.
     *
     * @param scope A CDK Construct that will serve as this resource's parent
     * in the construct tree.
     * @param id A name to be associated with the resource and used in resource
     * naming. Must be unique within the context of 'scope'.
     * @param props Arguments related to the configuration of the resource.
     */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
        });
        this.cluster = props.cluster;
        this.name = props.name ?? `ss${aws_cdk_lib_1.Names.uniqueId(this).slice(-61).toLowerCase()}`;
        this.namespace = props.namespace ?? 'default';
        this.service = props.service;
        if (!RegExp(AwsSecretStore.NAME_VALIDATOR_REGEX).test(this.name) || this.name.length > 63) {
            throw new Error([
                `Invalid external secret store name: '${this.name}'. Valid names`,
                'must be less than 64 characters long. They can only contain',
                'lowercase letters, numbers, hyphens, and dots. They must start',
                'and end with an alphanumeric character.',
            ].join(' '));
        }
        this.serviceAccount = new aws_eks_1.ServiceAccount(this, 'service-account', {
            cluster: this.cluster,
            name: `sa${aws_cdk_lib_1.Names.uniqueId(this).slice(-61)}`.toLowerCase(),
            namespace: this.namespace,
        });
        this.manifest = new aws_eks_1.KubernetesManifest(this, 'Resource', {
            cluster: this.cluster,
            manifest: [
                {
                    apiVersion: 'external-secrets.io/v1beta1',
                    kind: 'SecretStore',
                    metadata: {
                        name: this.name,
                        namespace: this.namespace,
                    },
                    spec: {
                        provider: {
                            aws: {
                                service: this.service,
                                region: this.stack.region,
                                auth: {
                                    jwt: {
                                        serviceAccountRef: {
                                            name: this.serviceAccount.serviceAccountName,
                                        },
                                    },
                                },
                            },
                        },
                    },
                },
            ],
        });
        this.manifest.node.addDependency(this.serviceAccount);
        this.secretStoreName = this.name;
    }
}
exports.AwsSecretStore = AwsSecretStore;
_a = JSII_RTTI_SYMBOL_1;
AwsSecretStore[_a] = { fqn: "cdk-extensions.k8s_aws.AwsSecretStore", version: "0.0.38" };
/**
 * The regex pattern used to validate secret store names.
 */
AwsSecretStore.NAME_VALIDATOR_REGEX = '^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$';
//# sourceMappingURL=data:application/json;base64,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