"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53Dns = exports.ExternalDnsZoneType = exports.ExternalDnsSyncPolicy = exports.ExternalDnsLogLevel = exports.ExternalDnsLogFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const _1 = require(".");
/**
 * The format external dns should use to output logs.
 */
var ExternalDnsLogFormat;
(function (ExternalDnsLogFormat) {
    /**
     * Output logs will be written as JSON objects.
     */
    ExternalDnsLogFormat["JSON"] = "json";
    /**
     * Output logs will be written in plain text.
     */
    ExternalDnsLogFormat["TEXT"] = "text";
})(ExternalDnsLogFormat = exports.ExternalDnsLogFormat || (exports.ExternalDnsLogFormat = {}));
/**
 * Verbosity of the logs generated by the external-dns service.
 */
var ExternalDnsLogLevel;
(function (ExternalDnsLogLevel) {
    /**
     * Set log level to 'panic'
     */
    ExternalDnsLogLevel["PANIC"] = "panic";
    /**
     * Set log level to 'debug'
     */
    ExternalDnsLogLevel["DEBUG"] = "debug";
    /**
     * Set log level to 'info'
     */
    ExternalDnsLogLevel["INFO"] = "info";
    /**
     * Set log level to 'warning'
     */
    ExternalDnsLogLevel["WARNING"] = "warning";
    /**
     * Set log level to 'error'
     */
    ExternalDnsLogLevel["ERROR"] = "error";
    /**
     * Set log level to 'fatal'
     */
    ExternalDnsLogLevel["FATAL"] = "fatal";
    /**
     * Set log level to 'trace'
     */
    ExternalDnsLogLevel["TRACE"] = "trace";
})(ExternalDnsLogLevel = exports.ExternalDnsLogLevel || (exports.ExternalDnsLogLevel = {}));
/**
 * Controls the operations ExternalDNS will perform on the records it manages.
 */
var ExternalDnsSyncPolicy;
(function (ExternalDnsSyncPolicy) {
    /**
     * Full sync mode. Records will be created, updated, and deleted based on the
     * statis of their backing resources on the Kubernetes cluster.
     */
    ExternalDnsSyncPolicy["SYNC"] = "sync";
    /**
     * Only allow create and update operations. Records will have their values
     * set based on the status of their backing Kubernetes resources, however if
     * those resources are removed the DNS records will be retained, set to their
     * last configured value.
     */
    ExternalDnsSyncPolicy["UPSERT_ONLY"] = "upsert-only";
})(ExternalDnsSyncPolicy = exports.ExternalDnsSyncPolicy || (exports.ExternalDnsSyncPolicy = {}));
/**
 * Controls the types of Hosted Zones external DNS will create records for.
 */
var ExternalDnsZoneType;
(function (ExternalDnsZoneType) {
    /**
     * Create DNS records for both public and private hosted zones.
     */
    ExternalDnsZoneType["ALL"] = "ALL";
    /**
     * Only create DNS records for private hosted zones.
     */
    ExternalDnsZoneType["PRIVATE"] = "private";
    /**
     * Only create DNS records for public hosted zones.
     */
    ExternalDnsZoneType["PUBLIC"] = "public";
})(ExternalDnsZoneType = exports.ExternalDnsZoneType || (exports.ExternalDnsZoneType = {}));
/**
 * External DNS is a Kubernetes service that make Kubernetes resources
 * dicoverable via public DNS servers. It retrieves a list of resources
 * (Services, Ingresses, etc.) from the Kubernetes API to determine a desired
 * list of DNS records and configures DNS providers accordingly.
 *
 * The version provided here specifically targets Amazon's Route 53 service and
 * all options provded are for configuring Route 53. After being installed
 * external-dns will create and manage Route 53 DNS records automatically to
 * allow easy network access to your pods and services.
 *
 * @see [Kubernetes SIGs](https://github.com/kubernetes-sigs/external-dns)
 */
class Route53Dns extends aws_cdk_lib_1.Resource {
    /**
     * Creates a new instance of the Route53Dns class.
     *
     * @param scope A CDK Construct that will serve as this resource's parent
     * in the construct tree.
     * @param id A name to be associated with the resource and used in resource
     * naming. Must be unique within the context of 'scope'.
     * @param props Arguments related to the configuration of the resource.
     */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
        });
        this._domainFilter = [];
        this._zoneTags = [];
        this.apiRetries = props.apiRetries;
        this.batchChangeSize = props.batchChangeSize;
        this.cluster = props.cluster;
        this.evaluateTargetHealth = props.evaluateTargetHealth;
        this.logFormat = props.logFormat ?? ExternalDnsLogFormat.JSON;
        this.logLevel = props.logLevel;
        this.namespace = props.namespace ?? Route53Dns.DEFAULT_NAMESPACE;
        this.preferCname = props.preferCname;
        this.recordOwnershipRegistry = props.recordOwnershipRegistry ?? _1.ExternalDnsRegistry.txt();
        this.region = props.region ?? this.stack.region;
        this.replicaCount = props.replicaCount;
        this.syncPolicy = props.syncPolicy ?? ExternalDnsSyncPolicy.SYNC;
        this.zoneType = props.zoneType ?? ExternalDnsZoneType.ALL;
        const registry = this.recordOwnershipRegistry.bind(this);
        this.serviceAccount = new aws_eks_1.ServiceAccount(this, 'service-account', {
            cluster: this.cluster,
            name: (aws_cdk_lib_1.Names.uniqueId(this) + 'sa').slice(-63).toLowerCase(),
            namespace: this.namespace,
        });
        this.serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'route53:ListHostedZones',
                'route53:ListResourceRecordSets',
            ],
            effect: aws_iam_1.Effect.ALLOW,
            resources: [
                '*',
            ],
        }));
        this.serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'route53:ChangeResourceRecordSets',
            ],
            effect: aws_iam_1.Effect.ALLOW,
            resources: [
                this.stack.formatArn({
                    account: '',
                    region: '',
                    resource: 'hostedzone',
                    resourceName: '*',
                    service: 'route53',
                }),
            ],
        }));
        registry.permissions?.forEach((x) => {
            this.serviceAccount.addToPrincipalPolicy(x);
        });
        this.chart = new aws_eks_1.HelmChart(this, 'helm-chart', {
            cluster: this.cluster,
            chart: Route53Dns.CHART_NAME,
            namespace: this.namespace,
            repository: Route53Dns.CHART_REPOSITORY,
            timeout: aws_cdk_lib_1.Duration.minutes(15),
            values: {
                ...(registry.properties ?? {}),
                aws: {
                    apiRetries: this.apiRetries,
                    batchChangeSize: this.batchChangeSize,
                    evaluateTargetHealth: this.evaluateTargetHealth,
                    preferCNAME: this.preferCname,
                    region: this.region,
                    zoneTags: aws_cdk_lib_1.Lazy.list({
                        produce: () => {
                            return this.zoneTags.map((x) => {
                                return `${x.key}=${x.value}`;
                            });
                        },
                    }, {
                        omitEmpty: true,
                    }),
                    zoneType: this.zoneType !== ExternalDnsZoneType.ALL ? this.zoneType : undefined,
                },
                domainFilters: aws_cdk_lib_1.Lazy.list({
                    produce: () => {
                        return this.domainFilter;
                    },
                }),
                logFormat: this.logFormat,
                logLevel: this.logLevel,
                policy: this.syncPolicy,
                provider: 'aws',
                publishService: {
                    enabled: true,
                },
                registry: registry.registryType,
                replicaCount: this.replicaCount,
                serviceAccount: {
                    create: false,
                    name: this.serviceAccount.serviceAccountName,
                },
            },
            wait: true,
        });
        props.domainFilter?.forEach((x) => {
            this.addDomainFilter(x);
        });
        props.zoneTags?.forEach((x) => {
            this.addZoneTag(x);
        });
    }
    /**
     * The domain suffixes that control which hosted zones external-dns is
     * allowed to make changes for.
     *
     * @group Inputs
     */
    get domainFilter() {
        return [...this._domainFilter];
    }
    /**
     * The AWS tags that control which hosted zones external-dns is allowed to
     * make changes for.
     *
     * @group Inputs
     */
    get zoneTags() {
        return [...this._zoneTags];
    }
    /**
     * Adds a domain to the domain filter list.
     *
     * The domain filter list acts as a whitelist for the domains/hosted zones
     * which external-dns will manage.
     *
     * When domains are added to the domain filter list, external-dns will only
     * create and manage records when their domain ends in with a domain that has
     * been approved.
     *
     * @param domain The domain to be added to the whitelist.
     * @returns The external-dns service object that the domain filter was added
     * for.
     */
    addDomainFilter(domain) {
        this._domainFilter.push(domain);
        return this;
    }
    /**
     * Adds a zone tag filter to the external DNS service.
     *
     * When zone tags are provided only Routew 53 Hosted Zones that have matching
     * tags will be managed by external DNS.
     *
     * @param tag The tag that external-dns is allowed to manage.
     * @returns The external-dns service object that the zone tag was added for.
     */
    addZoneTag(tag) {
        this._zoneTags.push(tag);
        return this;
    }
}
exports.Route53Dns = Route53Dns;
_a = JSII_RTTI_SYMBOL_1;
Route53Dns[_a] = { fqn: "cdk-extensions.k8s_aws.Route53Dns", version: "0.0.38" };
/**
 * The name of the external-dns Helm chart.
 */
Route53Dns.CHART_NAME = 'external-dns';
/**
 * The Helm repository providing the chart to be used for installing the
 * external-dns service.
 */
Route53Dns.CHART_REPOSITORY = 'https://kubernetes-sigs.github.io/external-dns/';
/**
 * The default Kubernetes namespace where external-dns will be installed if
 * an alternative isn't given as input.
 */
Route53Dns.DEFAULT_NAMESPACE = 'kube-system';
//# sourceMappingURL=data:application/json;base64,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