import { IConstruct } from 'constructs';
import { IExternalDnsRegistry } from '.';
import { ExternalDnsRegistryConfiguration } from './registry-base';
/**
 * An ExternalDNS registry that tracks DNS record ownership information using
 * AWS Service Discovery.
 *
 * @see [AWS Cloud Map](https://docs.aws.amazon.com/cloud-map/latest/dg/what-is-cloud-map.html)
 */
export declare class AwsServiceDiscoveryRegistry implements IExternalDnsRegistry {
    /**
       * The type name of ExternalDNS registry.
       */
    readonly registryType: string;
    /**
       * Creates a new instance of the AwsServiceDiscoveryRegistry class.
       */
    constructor();
    /**
       * Generates an object with all the information needed to use the registry
       * in a given CDK scope.
       *
       * @param scope The CDK resource that is configuring ExternalDNS.
       * @returns A configuration object representing the implementation of this
       * registry.
       */
    bind(scope: IConstruct): ExternalDnsRegistryConfiguration;
}
