"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsServiceDiscoveryRegistry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * An ExternalDNS registry that tracks DNS record ownership information using
 * AWS Service Discovery.
 *
 * @see [AWS Cloud Map](https://docs.aws.amazon.com/cloud-map/latest/dg/what-is-cloud-map.html)
 */
class AwsServiceDiscoveryRegistry {
    /**
       * Creates a new instance of the AwsServiceDiscoveryRegistry class.
       */
    constructor() {
        this.registryType = 'aws-sd';
    }
    /**
       * Generates an object with all the information needed to use the registry
       * in a given CDK scope.
       *
       * @param scope The CDK resource that is configuring ExternalDNS.
       * @returns A configuration object representing the implementation of this
       * registry.
       */
    bind(scope) {
        return {
            permissions: [
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'ec2:DescribeRegions',
                        'ec2:DescribeVpcs',
                        'route53:CreateHealthCheck',
                        'route53:CreateHostedZone',
                        'route53:ListHostedZonesByName',
                        'servicediscovery:*',
                    ],
                    effect: aws_iam_1.Effect.ALLOW,
                    resources: [
                        '*',
                    ],
                }),
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'route53:DeleteHealthCheck',
                        'route53:GetHealthCheck',
                        'route53:UpdateHealthCheck',
                    ],
                    effect: aws_iam_1.Effect.ALLOW,
                    resources: [
                        aws_cdk_lib_1.Stack.of(scope).formatArn({
                            account: '',
                            region: '',
                            resource: 'healthcheck',
                            resourceName: '*',
                            service: 'route53',
                        }),
                    ],
                }),
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'route53:ChangeResourceRecordSets',
                        'route53:GetHostedZone',
                        'route53:DeleteHostedZone',
                    ],
                    effect: aws_iam_1.Effect.ALLOW,
                    resources: [
                        aws_cdk_lib_1.Stack.of(scope).formatArn({
                            account: '',
                            region: '',
                            resource: 'hostedzone',
                            resourceName: '*',
                            service: 'route53',
                        }),
                    ],
                }),
            ],
            registryType: this.registryType,
        };
    }
}
exports.AwsServiceDiscoveryRegistry = AwsServiceDiscoveryRegistry;
_a = JSII_RTTI_SYMBOL_1;
AwsServiceDiscoveryRegistry[_a] = { fqn: "cdk-extensions.k8s_aws.AwsServiceDiscoveryRegistry", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLXNlcnZpY2UtZGlzY292ZXJ5LXJlZ2lzdHJ5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2s4cy1hd3MvbGliL2V4dGVybmFsLWRucy1yZWdpc3RyeS9hd3Mtc2VydmljZS1kaXNjb3ZlcnktcmVnaXN0cnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBb0M7QUFDcEMsaURBQThEO0FBTTlEOzs7OztHQUtHO0FBQ0gsTUFBYSwyQkFBMkI7SUFNdEM7O1NBRUs7SUFDTDtRQUNFLElBQUksQ0FBQyxZQUFZLEdBQUcsUUFBUSxDQUFDO0lBQy9CLENBQUM7SUFFRDs7Ozs7OztTQU9LO0lBQ0UsSUFBSSxDQUFDLEtBQWlCO1FBQzNCLE9BQU87WUFDTCxXQUFXLEVBQUU7Z0JBQ1gsSUFBSSx5QkFBZSxDQUFDO29CQUNsQixPQUFPLEVBQUU7d0JBQ1AscUJBQXFCO3dCQUNyQixrQkFBa0I7d0JBQ2xCLDJCQUEyQjt3QkFDM0IsMEJBQTBCO3dCQUMxQiwrQkFBK0I7d0JBQy9CLG9CQUFvQjtxQkFDckI7b0JBQ0QsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztvQkFDcEIsU0FBUyxFQUFFO3dCQUNULEdBQUc7cUJBQ0o7aUJBQ0YsQ0FBQztnQkFDRixJQUFJLHlCQUFlLENBQUM7b0JBQ2xCLE9BQU8sRUFBRTt3QkFDUCwyQkFBMkI7d0JBQzNCLHdCQUF3Qjt3QkFDeEIsMkJBQTJCO3FCQUM1QjtvQkFDRCxNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO29CQUNwQixTQUFTLEVBQUU7d0JBQ1QsbUJBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDOzRCQUN4QixPQUFPLEVBQUUsRUFBRTs0QkFDWCxNQUFNLEVBQUUsRUFBRTs0QkFDVixRQUFRLEVBQUUsYUFBYTs0QkFDdkIsWUFBWSxFQUFFLEdBQUc7NEJBQ2pCLE9BQU8sRUFBRSxTQUFTO3lCQUNuQixDQUFDO3FCQUNIO2lCQUNGLENBQUM7Z0JBQ0YsSUFBSSx5QkFBZSxDQUFDO29CQUNsQixPQUFPLEVBQUU7d0JBQ1Asa0NBQWtDO3dCQUNsQyx1QkFBdUI7d0JBQ3ZCLDBCQUEwQjtxQkFDM0I7b0JBQ0QsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztvQkFDcEIsU0FBUyxFQUFFO3dCQUNULG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsQ0FBQzs0QkFDeEIsT0FBTyxFQUFFLEVBQUU7NEJBQ1gsTUFBTSxFQUFFLEVBQUU7NEJBQ1YsUUFBUSxFQUFFLFlBQVk7NEJBQ3RCLFlBQVksRUFBRSxHQUFHOzRCQUNqQixPQUFPLEVBQUUsU0FBUzt5QkFDbkIsQ0FBQztxQkFDSDtpQkFDRixDQUFDO2FBQ0g7WUFDRCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDaEMsQ0FBQztJQUNKLENBQUM7O0FBM0VILGtFQTRFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgRWZmZWN0LCBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElFeHRlcm5hbERuc1JlZ2lzdHJ5IH0gZnJvbSAnLic7XG5pbXBvcnQgeyBFeHRlcm5hbERuc1JlZ2lzdHJ5Q29uZmlndXJhdGlvbiB9IGZyb20gJy4vcmVnaXN0cnktYmFzZSc7XG5cblxuLyoqXG4gKiBBbiBFeHRlcm5hbEROUyByZWdpc3RyeSB0aGF0IHRyYWNrcyBETlMgcmVjb3JkIG93bmVyc2hpcCBpbmZvcm1hdGlvbiB1c2luZ1xuICogQVdTIFNlcnZpY2UgRGlzY292ZXJ5LlxuICpcbiAqIEBzZWUgW0FXUyBDbG91ZCBNYXBdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbG91ZC1tYXAvbGF0ZXN0L2RnL3doYXQtaXMtY2xvdWQtbWFwLmh0bWwpXG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NTZXJ2aWNlRGlzY292ZXJ5UmVnaXN0cnkgaW1wbGVtZW50cyBJRXh0ZXJuYWxEbnNSZWdpc3RyeSB7XG4gIC8qKlxuICAgICAqIFRoZSB0eXBlIG5hbWUgb2YgRXh0ZXJuYWxETlMgcmVnaXN0cnkuXG4gICAgICovXG4gIHB1YmxpYyByZWFkb25seSByZWdpc3RyeVR5cGU6IHN0cmluZztcblxuICAvKipcbiAgICAgKiBDcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBBd3NTZXJ2aWNlRGlzY292ZXJ5UmVnaXN0cnkgY2xhc3MuXG4gICAgICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcigpIHtcbiAgICB0aGlzLnJlZ2lzdHJ5VHlwZSA9ICdhd3Mtc2QnO1xuICB9XG5cbiAgLyoqXG4gICAgICogR2VuZXJhdGVzIGFuIG9iamVjdCB3aXRoIGFsbCB0aGUgaW5mb3JtYXRpb24gbmVlZGVkIHRvIHVzZSB0aGUgcmVnaXN0cnlcbiAgICAgKiBpbiBhIGdpdmVuIENESyBzY29wZS5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSBUaGUgQ0RLIHJlc291cmNlIHRoYXQgaXMgY29uZmlndXJpbmcgRXh0ZXJuYWxETlMuXG4gICAgICogQHJldHVybnMgQSBjb25maWd1cmF0aW9uIG9iamVjdCByZXByZXNlbnRpbmcgdGhlIGltcGxlbWVudGF0aW9uIG9mIHRoaXNcbiAgICAgKiByZWdpc3RyeS5cbiAgICAgKi9cbiAgcHVibGljIGJpbmQoc2NvcGU6IElDb25zdHJ1Y3QpOiBFeHRlcm5hbERuc1JlZ2lzdHJ5Q29uZmlndXJhdGlvbiB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHBlcm1pc3Npb25zOiBbXG4gICAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICdlYzI6RGVzY3JpYmVSZWdpb25zJyxcbiAgICAgICAgICAgICdlYzI6RGVzY3JpYmVWcGNzJyxcbiAgICAgICAgICAgICdyb3V0ZTUzOkNyZWF0ZUhlYWx0aENoZWNrJyxcbiAgICAgICAgICAgICdyb3V0ZTUzOkNyZWF0ZUhvc3RlZFpvbmUnLFxuICAgICAgICAgICAgJ3JvdXRlNTM6TGlzdEhvc3RlZFpvbmVzQnlOYW1lJyxcbiAgICAgICAgICAgICdzZXJ2aWNlZGlzY292ZXJ5OionLFxuICAgICAgICAgIF0sXG4gICAgICAgICAgZWZmZWN0OiBFZmZlY3QuQUxMT1csXG4gICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICAnKicsXG4gICAgICAgICAgXSxcbiAgICAgICAgfSksXG4gICAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICdyb3V0ZTUzOkRlbGV0ZUhlYWx0aENoZWNrJyxcbiAgICAgICAgICAgICdyb3V0ZTUzOkdldEhlYWx0aENoZWNrJyxcbiAgICAgICAgICAgICdyb3V0ZTUzOlVwZGF0ZUhlYWx0aENoZWNrJyxcbiAgICAgICAgICBdLFxuICAgICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgICAgIHJlc291cmNlczogW1xuICAgICAgICAgICAgU3RhY2sub2Yoc2NvcGUpLmZvcm1hdEFybih7XG4gICAgICAgICAgICAgIGFjY291bnQ6ICcnLFxuICAgICAgICAgICAgICByZWdpb246ICcnLFxuICAgICAgICAgICAgICByZXNvdXJjZTogJ2hlYWx0aGNoZWNrJyxcbiAgICAgICAgICAgICAgcmVzb3VyY2VOYW1lOiAnKicsXG4gICAgICAgICAgICAgIHNlcnZpY2U6ICdyb3V0ZTUzJyxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBhY3Rpb25zOiBbXG4gICAgICAgICAgICAncm91dGU1MzpDaGFuZ2VSZXNvdXJjZVJlY29yZFNldHMnLFxuICAgICAgICAgICAgJ3JvdXRlNTM6R2V0SG9zdGVkWm9uZScsXG4gICAgICAgICAgICAncm91dGU1MzpEZWxldGVIb3N0ZWRab25lJyxcbiAgICAgICAgICBdLFxuICAgICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgICAgIHJlc291cmNlczogW1xuICAgICAgICAgICAgU3RhY2sub2Yoc2NvcGUpLmZvcm1hdEFybih7XG4gICAgICAgICAgICAgIGFjY291bnQ6ICcnLFxuICAgICAgICAgICAgICByZWdpb246ICcnLFxuICAgICAgICAgICAgICByZXNvdXJjZTogJ2hvc3RlZHpvbmUnLFxuICAgICAgICAgICAgICByZXNvdXJjZU5hbWU6ICcqJyxcbiAgICAgICAgICAgICAgc2VydmljZTogJ3JvdXRlNTMnLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgXSxcbiAgICAgICAgfSksXG4gICAgICBdLFxuICAgICAgcmVnaXN0cnlUeXBlOiB0aGlzLnJlZ2lzdHJ5VHlwZSxcbiAgICB9O1xuICB9XG59Il19