"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoopRegistry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A placeholder ExternalDNS registry that says ExternalDNS should use not use
 * a registry.
 *
 * When configuring ExternalDNS without a registry, the service has no idea the
 * original creator and maintainer of DNS records. This means that there are
 * likely to be conflicts if there are multiple services that could create or
 * change DNS records in the same zone.
 */
class NoopRegistry {
    /**
       * Creates a new instance of the NoopRegistry class.
       */
    constructor() {
        this.registryType = 'noop';
    }
    /**
       * Generates an object with all the information needed to use the registry
       * in a given CDK scope.
       *
       * @param _scope The CDK resource that is configuring ExternalDNS.
       * @returns A configuration object representing the implementation of this
       * registry.
       */
    bind(_scope) {
        return {
            registryType: this.registryType,
        };
    }
}
exports.NoopRegistry = NoopRegistry;
_a = JSII_RTTI_SYMBOL_1;
NoopRegistry[_a] = { fqn: "cdk-extensions.k8s_aws.NoopRegistry", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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