"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalDnsRegistry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_service_discovery_registry_1 = require("./aws-service-discovery-registry");
const noop_registry_1 = require("./noop-registry");
const txt_registry_1 = require("./txt-registry");
/**
 * Helper class that provides access to the available ExternalDns registry
 * options.
 */
class ExternalDnsRegistry {
    /**
       * An ExternalDNS registry that tracks DNS record ownership information
       * using AWS Service Discovery.
       *
       * @see [AWS Cloud Map](https://docs.aws.amazon.com/cloud-map/latest/dg/what-is-cloud-map.html)
       *
       * @returns A ExternalDNS registry object configured to use AWS Cloud Map
       * for ownership information.
       */
    static awsServiceDiscovery() {
        return new aws_service_discovery_registry_1.AwsServiceDiscoveryRegistry();
    }
    /**
       * A placeholder ExternalDNS registry that says ExternalDNS should use not
       * use a registry.
       *
       * When configuring ExternalDNS without a registry, the service has no idea
       * the original creator and maintainer of DNS records. This means that
       * there are likely to be conflicts if there are multiple services that
       * could create or change DNS records in the same zone.
       *
       * @returns An object that instructs ExternalDNS to not store record
       * ownership information and will perform record updates without
       * validation.
       */
    static noop() {
        return new noop_registry_1.NoopRegistry();
    }
    /**
       * An ExternalDNS registry that tracks DNS record ownership information
       * using DNS TXT records.
       *
       * @see [About TXT records](https://support.google.com/a/answer/2716800?hl=en)
       *
       * @param options Options configuring how ExternalDNS will use TXT records
       * to validate ownership.
       * @returns A ExternalDNS registry object configured to use DNS TXT records
       * for ownership information.
       */
    static txt(options = {}) {
        return new txt_registry_1.TxtRegistry(options);
    }
}
exports.ExternalDnsRegistry = ExternalDnsRegistry;
_a = JSII_RTTI_SYMBOL_1;
ExternalDnsRegistry[_a] = { fqn: "cdk-extensions.k8s_aws.ExternalDnsRegistry", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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