"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TxtRegistry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An ExternalDNS registry that tracks DNS record ownership information using
 * DNS TXT records.
 *
 * @see [About TXT records](https://support.google.com/a/answer/2716800?hl=en)
 */
class TxtRegistry {
    /**
       * Creates a new instance of the NoopRegistry class.
       *
       * @param options Options configuring how ExternalDNS will use TXT records
       * to validate ownership.
       */
    constructor(options = {}) {
        this.registryType = 'txt';
        this.ownerId = options.ownerId;
        this.prefix = options.prefix === TxtRegistry.NO_PREFIX ? undefined : (options.prefix ?? TxtRegistry.DEFAULT_PREFIX);
    }
    /**
       * Generates an object with all the information needed to use the registry
       * in a given CDK scope.
       *
       * @param scope The CDK resource that is configuring ExternalDNS.
       * @returns A configuration object representing the implementation of this
       * registry.
       */
    bind(scope) {
        return {
            properties: {
                txtOwnerId: this.ownerId ?? scope.node.addr,
                txtPrefix: this.prefix,
            },
            registryType: this.registryType,
        };
    }
}
exports.TxtRegistry = TxtRegistry;
_a = JSII_RTTI_SYMBOL_1;
TxtRegistry[_a] = { fqn: "cdk-extensions.k8s_aws.TxtRegistry", version: "0.0.38" };
/**
   * The default prefix to append to TXT ownership records creates for the
   * registry.
   */
TxtRegistry.DEFAULT_PREFIX = 'edns.';
/**
   * A special value that specifies ExternalDNS should not use any prefix
   * when creating TXT ownership records.
   *
   * This is not recommended as it is likely to cause issues with record
   * creation and management with some record types that do not allow other
   * records with the same name and different types to exist (CNAME's).
   *
   * However, if this behavior is desired this value can be passed as the
   * prefix to override the default behavior with will set a prefix if none
   * is provided as input.
   */
TxtRegistry.NO_PREFIX = '::NO_PREFIX::';
//# sourceMappingURL=data:application/json;base64,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