"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitCustomFilterPlugin = void 0;
const _1 = require(".");
/**
 * A Fluent Bit plugin that allows for configuration of options and can be
 * used to configure logging from containers.
 */
class FluentBitCustomFilterPlugin extends _1.FluentBitFilterPluginBase {
    /**
       * Creates a new instance of the FluentBitCustomFilterPlugin class.
       *
       * @param options Configuration options for the plugin.
       */
    constructor(options) {
        super(options.name);
        this._fields = {};
    }
    /**
       * Collection of all the fields to be added to the Fluent Bit
       * configuration.
       */
    get fields() {
        return Object.keys(this._fields).reduce((prev, cur) => {
            prev[cur] = this._fields[cur].map((x) => {
                return String(x);
            });
            return prev;
        }, {});
    }
    /**
        * Adds a new field to the Fluent Bit plugin configuration.
        *
        * @param key The name of the property being set.
        * @param values The values of the property being set.
        * @returns The Fluent Bit plugin configuration where the property was
        * added.
        */
    addField(key, ...values) {
        if (key in this._fields) {
            this._fields[key].concat(values);
        }
        else {
            this._fields[key] = [...values];
        }
        return this;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: this.renderConfigFile(this._fields),
        };
    }
}
exports.FluentBitCustomFilterPlugin = FluentBitCustomFilterPlugin;
//# sourceMappingURL=data:application/json;base64,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