"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitFilterPluginBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fluent_bit_plugin_1 = require("../fluent-bit-plugin");
const match_1 = require("../match");
class FluentBitFilterPluginBase extends fluent_bit_plugin_1.FluentBitPlugin {
    /**
     * Creates a new instance of the FluentBitOutputPlugin class.
     *
     * @param name The name of the output plugin to configure.
     * @param options Configuration options that apply to all Fluent Bit output
     * plugin.
     */
    constructor(name, options = {}) {
        super({
            name: name,
            pluginType: fluent_bit_plugin_1.FluentBitPluginType.FILTER,
        });
        this.match = options.match ?? match_1.FluentBitMatch.ALL;
    }
    /**
     * Renders a Fluent Bit configuration file for the plugin.
     *
     * @param config The configuration options to render into a configuration
     * file.
     * @returns A rendered plugin configuration file.
     */
    renderConfigFile(config) {
        return super.renderConfigFile({
            ...this.match.toObject(),
            ...config,
        });
    }
}
exports.FluentBitFilterPluginBase = FluentBitFilterPluginBase;
_a = JSII_RTTI_SYMBOL_1;
FluentBitFilterPluginBase[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitFilterPluginBase", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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