"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitGrepFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * A Fluent Bit filter that allows log records to be kept or discarded based
 * on whether they match a given regular expression or not.
 */
class FluentBitGrepFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
     * Creates a new instance of the FluentBitKinesisFirehoseOutput class.
     *
     * @param options Options for configuring the filter.
     */
    constructor(options) {
        super('grep', options);
        this.pattern = options.pattern;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        const key = (this.pattern.exclude ?? false) ? 'Exclude' : 'Regex';
        return {
            configFile: super.renderConfigFile({
                [key]: `${this.pattern.key} ${this.pattern.regex}`,
            }),
        };
    }
}
exports.FluentBitGrepFilter = FluentBitGrepFilter;
_a = JSII_RTTI_SYMBOL_1;
FluentBitGrepFilter[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitGrepFilter", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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