"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitKubernetesFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("../utils");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * A Fluent Bit filter that allows log records to be annotated with Kubernetes
 * metadata based on the containers that generated them.
 */
class FluentBitKubernetesFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
     * Creates a new instance of the FluentBitKubernetesFilter class.
     *
     * @param options Options for configuring the filter.
     */
    constructor(options = {}) {
        super(FluentBitKubernetesFilter.PLUGIN_NAME, options);
        this.annotations = options.annotations;
        this.bufferSize = options.bufferSize;
        this.cacheUseDockerId = options.cacheUseDockerId;
        this.dnsRetries = options.dnsRetries;
        this.dnsWaitTime = options.dnsWaitTime;
        this.dummyMeta = options.dummyMeta;
        this.k8sLoggingExclude = options.k8sLoggingExclude;
        this.k8sLoggingParser = options.k8sLoggingParser;
        this.keepLog = options.keepLog;
        this.kubeCaFile = options.kubeCaFile;
        this.kubeCaPath = options.kubeCaPath;
        this.kubeMetaCacheTtl = options.kubeMetaCacheTtl;
        this.kubeMetaPreloadCacheDir = options.kubeMetaPreloadCacheDir;
        this.kubeTagPrefix = options.kubeTagPrefix;
        this.kubeTokenCommand = options.kubeTokenCommand;
        this.kubeTokenFile = options.kubeTokenFile;
        this.kubeTokenTtl = options.kubeTokenTtl;
        this.kubeUrl = options.kubeUrl;
        this.kubeletHost = options.kubeletHost;
        this.kubeletPort = options.kubeletPort;
        this.labels = options.labels;
        this.mergeLog = options.mergeLog;
        this.mergeLogKey = options.mergeLogKey;
        this.mergeLogTrim = options.mergeLogTrim;
        this.mergeParser = options.mergeParser;
        this.regexParser = options.regexParser;
        this.tlsDebug = options.tlsDebug;
        this.tlsVerify = options.tlsVerify;
        this.useJournal = options.useJournal;
        this.useKubelet = options.useKubelet;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: super.renderConfigFile({
                'Annotations': utils_1.convertBool(this.annotations),
                'Buffer_Size': this.bufferSize?.toBytes(),
                'Cache_Use_Docker_Id': utils_1.convertBool(this.cacheUseDockerId),
                'DNS_Retries': this.dnsRetries,
                'DNS_Wait_Time': this.dnsWaitTime?.toSeconds(),
                'Dummy_Meta': utils_1.convertBool(this.dummyMeta),
                'K8S-Logging.Exclude': utils_1.convertBool(this.k8sLoggingExclude),
                'K8S-Logging.Parser': utils_1.convertBool(this.k8sLoggingParser),
                'Keep_Log': utils_1.convertBool(this.keepLog),
                'Kube_CA_File': this.kubeCaFile,
                'Kube_CA_Path': this.kubeCaPath,
                'Kube_Meta_Cache_TTL': this.kubeMetaCacheTtl?.toSeconds(),
                'Kube_meta_preload_cache_dir': this.kubeMetaPreloadCacheDir,
                'Kube_Tag_Prefix': this.kubeTagPrefix,
                'Kube_Token_Command': this.kubeTokenCommand,
                'Kube_Token_File': this.kubeTokenFile,
                'Kube_Token_TTL': this.kubeTokenTtl?.toSeconds(),
                'Kube_URL': this.kubeUrl,
                'Kubelet_Host': this.kubeletHost,
                'Kubelet_Port': this.kubeletPort,
                'Labels': utils_1.convertBool(this.labels),
                'Merge_Log': utils_1.convertBool(this.mergeLog),
                'Merge_Log_Key': this.mergeLogKey,
                'Merge_Log_Trim': utils_1.convertBool(this.mergeLogTrim),
                'Merge_Parser': this.mergeParser,
                'Regex_Parser': this.regexParser,
                'tls.debug': this.tlsDebug,
                'tls.verify': utils_1.convertBool(this.tlsVerify),
                'Use_Journal': utils_1.convertBool(this.useJournal),
                'Use_Kubelet': utils_1.convertBool(this.useKubelet),
            }),
        };
    }
}
exports.FluentBitKubernetesFilter = FluentBitKubernetesFilter;
_a = JSII_RTTI_SYMBOL_1;
FluentBitKubernetesFilter[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitKubernetesFilter", version: "0.0.38" };
/**
  * The name of the plugin as it will appear in the fluent bit configuration.
  */
FluentBitKubernetesFilter.PLUGIN_NAME = 'kubernetes';
//# sourceMappingURL=data:application/json;base64,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