"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitModifyFilter = exports.ModifyOperation = exports.ModifyCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const filter_plugin_base_1 = require("./filter-plugin-base");
class ModifyCondition {
    /**
       * Creates a new instance of the ModifyCondition class.
       *
       * @param condition The name of the condition being performed.
       * @param args The arguments that apply to the condition.
       */
    constructor(condition, args) {
        this.condition = condition;
        this._args = args;
    }
    /**
       * Condition that returns true if any key matches a specified regular
       * expression.
       *
       * @param regex The regular expression to evaluate against field keys.
       * @returns A ModifyCondition object representing the condition.
       */
    static aKeyMatches(regex) {
        return ModifyCondition.of('A_key_matches', [
            regex,
        ]);
    }
    /**
       * Condition that returns true if a specified key does not exist.
       *
       * @param key The key to check for existence.
       * @returns A ModifyCondition object representing the condition.
       */
    static keyDoesNotExists(key) {
        return ModifyCondition.of('Key_does_not_exist', [
            key,
        ]);
    }
    /**
       * Condition that returns true if a specified key exists.
       *
       * @param key The key to check for existence.
       * @returns A ModifyCondition object representing the condition.
       */
    static keyExists(key) {
        return ModifyCondition.of('Key_exists', [
            key,
        ]);
    }
    /**
       * Condition that returns true if a specified key exists and its value
       * does not match the specified value.
       *
       * @param key The key to check for existence.
       * @param value The value to check for the given key.
       * @returns A ModifyCondition object representing the condition.
       */
    static keyValueDoesNotEqual(key, value) {
        return ModifyCondition.of('Key_value_does_not_equal', [
            key,
            value,
        ]);
    }
    /**
       * Condition that returns true if a specified key exists and its value
       * does not match the specified regular expression.
       *
       * @param key The key to check for existence.
       * @param value The regular expression to check for the given key.
       * @returns A ModifyCondition object representing the condition.
       */
    static keyValueDoesNotMatch(key, value) {
        return ModifyCondition.of('Key_value_does_not_match', [
            key,
            value,
        ]);
    }
    /**
       * Condition that returns true if a specified key exists and its value
       * matches the specified regular expression.
       *
       * @param key The key to check for existence.
       * @param value The regular expression to match for the given key.
       * @returns A ModifyCondition object representing the condition.
       */
    static keyValueMatches(key, value) {
        return ModifyCondition.of('Key_value_matches', [
            key,
            value,
        ]);
    }
    /**
       * Condition that returns true if a specified key exists and its value
       * matches the specified value.
       *
       * @param key The key to check for existence.
       * @param value The value to match for the given key.
       * @returns A ModifyCondition object representing the condition.
       */
    static keyValueEquals(key, value) {
        return ModifyCondition.of('Key_value_equals', [
            key,
            value,
        ]);
    }
    /**
       * Condition that returns true if all keys matching a specified regular
       * expression have values that do not match another regular expression.
       *
       * @param key The regular expression to use to filter keys.
       * @param value The regular expression to check the value of fields.
       * @returns A ModifyCondition object representing the condition.
       */
    static matchingKeysDoNotHaveMatchingValues(key, value) {
        return ModifyCondition.of('Matching_keys_do_not_have_matching_values', [
            key,
            value,
        ]);
    }
    /**
       * Condition that returns true if all keys matching a specified regular
       * expression have values that match another regular expression.
       *
       * @param key The regular expression to use to filter keys.
       * @param value The regular expression to check the value of fields.
       * @returns A ModifyCondition object representing the condition.
       */
    static matchingKeysHaveMatchingValues(key, value) {
        return ModifyCondition.of('Matching_keys_have_matching_values', [
            key,
            value,
        ]);
    }
    /**
       * Condition that returns true if no key matches a specified regular
       * expression.
       *
       * @param regex The regular expression to evaluate against field keys.
       * @returns A ModifyCondition object representing the condition.
       */
    static noKeyMatches(regex) {
        return ModifyCondition.of('No_key_matches', [
            regex,
        ]);
    }
    /**
       * An escape hatch method that allows fo defining custom conditions to be
       * evaluated by the modify Fluent Bit filter plugin.
       *
       * @param condition The name of the condition to be evaluated.
       * @param args The arguments to the operation.
       * @returns A ModifyCondition object representing the options provided.
       */
    static of(condition, args) {
        return new ModifyCondition(condition, args);
    }
    /**
       * Collection of arguments that apply to the condition.
       */
    get args() {
        return this._args;
    }
    /**
       * Gets a string representation of the arguments of this condition for use
       * in a Fluent Bit plugin field.
       *
       * @returns A fluent bit value string.
       */
    toString() {
        return this.args.join(' ');
    }
}
exports.ModifyCondition = ModifyCondition;
_a = JSII_RTTI_SYMBOL_1;
ModifyCondition[_a] = { fqn: "cdk-extensions.k8s_aws.ModifyCondition", version: "0.0.38" };
class ModifyOperation {
    /**
       * Creates a new instance of the Modify operations class.
       *
       * @param operation The name of the operation being performed.
       * @param args The arguments that apply to the operation.
       */
    constructor(operation, args) {
        this.operation = operation;
        this._args = args;
    }
    /**
       * Sets a field in the output to a specific value.
       *
       * If a field with the same name already exists it will be kept as is.
       *
       * @param key The key name of the field to set.
       * @param value The value to set for the specified field.
       * @returns A ModifyOperation object representing the add operation.
       */
    static add(key, value) {
        return ModifyOperation.of('Add', [
            key,
            value,
        ]);
    }
    /**
       * Copies a field from the input to a field with a new name if the field
       * exists and a field with the new name does not exist.
       *
       * If a field with the new name already exists it is overwritten.
       *
       * @param originalKey The key in the input to be copied.
       * @param newKey The new name of the field to be copied to.
       * @returns A ModifyOperation object representing the copy operation.
       */
    static copy(originalKey, newKey) {
        return ModifyOperation.of('Copy', [
            originalKey,
            newKey,
        ]);
    }
    /**
       * Copies a field from the input to a field with a new name if the field
       * exists and a field with the new name does not exist.
       *
       * @param originalKey The key in the input to be copied.
       * @param newKey The new name of the field to be copied to.
       * @returns A ModifyOperation object representing the copy operation.
       */
    static hardCopy(originalKey, newKey) {
        return ModifyOperation.of('Hard_copy', [
            originalKey,
            newKey,
        ]);
    }
    /**
       * Renames a field from the input if the field exists.
       *
       * If a field with the desired name already exists it is overwritten.
       *
       * @param originalKey The key in the input to be renamed.
       * @param renamedKey The new name of the key in the output.
       * @returns A ModifyOperation object representing the rename operation.
       */
    static hardRename(originalKey, renamedKey) {
        return ModifyOperation.of('Hard_rename', [
            originalKey,
            renamedKey,
        ]);
    }
    /**
       * Moves fiels matching the given wildcard key to the end of the message.
       *
       * @param key The wildcard to to match.
       * @returns A ModifyOperation object representing the move operation.
       */
    static moveToEnd(key) {
        return ModifyOperation.of('Move_to_end', [
            key,
        ]);
    }
    /**
       * Moves fiels matching the given wildcard key to the start of the message.
       *
       * @param key The wildcard to to match.
       * @returns A ModifyOperation object representing the move operation.
       */
    static moveToStart(key) {
        return ModifyOperation.of('Move_to_start', [
            key,
        ]);
    }
    /**
       * Removes a field in the output with a specific key.
       *
       * @param key The key name of the field to remove.
       * @returns A ModifyOperation object representing the remove operation.
       */
    static remove(key) {
        return ModifyOperation.of('Remove', [
            key,
        ]);
    }
    /**
       * Removes all fields in the output matching the regular expression.
       *
       * @param regex The regular expression specifying which fields to remove.
       * @returns A ModifyOperation object representing the remove operation.
       */
    static removeRegex(regex) {
        return ModifyOperation.of('Remove_regex', [
            regex,
        ]);
    }
    /**
       * Removes all fields in the output matching the wildcard key.
       *
       * @param key The wildcard expression specifying which fields to remove.
       * @returns A ModifyOperation object representing the remove operation.
       */
    static removeWildcard(key) {
        return ModifyOperation.of('Remove_wildcard', [
            key,
        ]);
    }
    /**
       * Renames a field from the input if the field exists and a field with the
       * new name does not exist.
       *
       * @param originalKey The key in the input to be renamed.
       * @param renamedKey The new name of the key in the output.
       * @returns A ModifyOperation object representing the rename operation.
       */
    static rename(originalKey, renamedKey) {
        return ModifyOperation.of('Rename', [
            originalKey,
            renamedKey,
        ]);
    }
    /**
       * Sets a field in the output to a specific value.
       *
       * If a field with the same name already exists it will be overridden with
       * the specified value.
       *
       * @param key The key name of the field to set.
       * @param value The value to set for the specified field.
       * @returns A ModifyOperation object representing the set operation.
       */
    static set(key, value) {
        return ModifyOperation.of('Set', [
            key,
            value,
        ]);
    }
    /**
       * An escape hatch method that allows fo defining custom operations to be
       * performed by the modify Fluent Bit filter plugin.
       *
       * @param operation The name of the operation to be performed.
       * @param args The arguments to the operation.
       * @returns A ModifyOperation object representing the options provided.
       */
    static of(operation, args) {
        return new ModifyOperation(operation, args);
    }
    /**
       * Collection of arguments that apply to the operation.
       */
    get args() {
        return this._args;
    }
    /**
       * Gets a string representation of the arguments of this operation for use
       * in a Fluent Bit plugin field.
       *
       * @returns A fluent bit value string.
       */
    toString() {
        return this.args.join(' ');
    }
}
exports.ModifyOperation = ModifyOperation;
_b = JSII_RTTI_SYMBOL_1;
ModifyOperation[_b] = { fqn: "cdk-extensions.k8s_aws.ModifyOperation", version: "0.0.38" };
/**
 * A Fluent Bit filter that allows changing records using rules and conditions.
 */
class FluentBitModifyFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
       * Creates a new instance of the FluentBitModifyFilter class.
       *
       * @param options The configuration options to use for filter.
       */
    constructor(options = {}) {
        super('modify', options);
        this._conditions = [];
        this._operations = [];
        options.conditions?.forEach((x) => {
            this.addCondition(x);
        });
        options.operations?.forEach((x) => {
            this.addOperation(x);
        });
    }
    /**
       * Collection of conditions to apply for the filter.
       */
    get conditions() {
        return [...this._conditions];
    }
    /**
       * Collection of operations to apply for the filter.
       */
    get operations() {
        return [...this._operations];
    }
    /**
       * Adds a new condition to the modify filter.
       *
       * All conditions must evaluate to `true` in order for operations are
       * performed.
       *
       * If one or more conditions do not evaluate to true, no conditions are
       * performed.
       *
       * @param condition The condition to add to the filter.
       * @returns The modify filter to which the condition was added.
       */
    addCondition(condition) {
        this._conditions.push(condition);
        return this;
    }
    /**
       * Adds a new operation to the modify filter.
       *
       * @param operation The operation to add to the filter.
       * @returns The modify filter to which the operation was added.
       */
    addOperation(operation) {
        this._operations.push(operation);
        return this;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        if (this._operations.length === 0) {
            throw new Error([
                'At least one operation must be specified when creating a Fluent Bit',
                'record modifier filter.',
            ].join(' '));
        }
        return {
            configFile: this.renderConfigFile({
                ...(this.conditions.reduce((prev, cur) => {
                    const args = cur.args.join(' ');
                    if (cur.condition in prev) {
                        prev[cur.condition].push(args);
                    }
                    else {
                        prev[cur.condition] = [
                            args,
                        ];
                    }
                    return prev;
                }, {})),
                ...(this.operations.reduce((prev, cur) => {
                    const args = cur.args.join(' ');
                    if (cur.operation in prev) {
                        prev[cur.operation].push(args);
                    }
                    else {
                        prev[cur.operation] = [
                            args,
                        ];
                    }
                    return prev;
                }, {})),
            }),
        };
    }
}
exports.FluentBitModifyFilter = FluentBitModifyFilter;
_c = JSII_RTTI_SYMBOL_1;
FluentBitModifyFilter[_c] = { fqn: "cdk-extensions.k8s_aws.FluentBitModifyFilter", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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