"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitNestFilter = exports.NestFilterOperation = exports.NestFilterOperationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * The modes that the Fluent Bit Nest filter plugin can work in.
 */
var NestFilterOperationType;
(function (NestFilterOperationType) {
    /**
       * Lift data from a nested object.
       */
    NestFilterOperationType["LIFT"] = "lift";
    /**
       * Nest data into a specified object.
       */
    NestFilterOperationType["NEST"] = "nest";
})(NestFilterOperationType = exports.NestFilterOperationType || (exports.NestFilterOperationType = {}));
/**
 * Operations with exclusive options that can be performed by the Fluent Bit
 * Nest filter plugin.
 */
class NestFilterOperation {
    /**
       * Creates a new instance of the NestFilterOperation class.
       *
       * @param operation The type of operation to be performed.
       * @param fields The fields representing configuration options for the
       * operation.
       */
    constructor(operation, fields) {
        this.fields = fields;
        this.operation = operation;
    }
    static lift(options) {
        return new NestFilterOperation(NestFilterOperationType.LIFT, {
            Nested_under: [
                options.nestedUnder,
            ],
        });
    }
    static nest(options) {
        return new NestFilterOperation(NestFilterOperationType.NEST, {
            Nest_under: [
                options.nestUnder,
            ],
            Wildcard: options.wildcards,
        });
    }
}
exports.NestFilterOperation = NestFilterOperation;
_a = JSII_RTTI_SYMBOL_1;
NestFilterOperation[_a] = { fqn: "cdk-extensions.k8s_aws.NestFilterOperation", version: "0.0.38" };
/**
 * A Fluent Bit filter that allows operating on or with nested data.
 */
class FluentBitNestFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
       * Creates a new instance of the FluentBitNestFilter class.
       *
       * @param options The configuration options for the plugin.
       */
    constructor(options) {
        super('nest', options);
        this.addPrefix = options.addPrefix;
        this.operation = options.operation;
        this.removePrefix = options.removePrefix;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        return {
            configFile: this.renderConfigFile({
                Add_prefix: this.addPrefix,
                Operation: this.operation.operation,
                Remove_prefix: this.removePrefix,
                ...this.operation.fields,
            }),
        };
    }
}
exports.FluentBitNestFilter = FluentBitNestFilter;
_b = JSII_RTTI_SYMBOL_1;
FluentBitNestFilter[_b] = { fqn: "cdk-extensions.k8s_aws.FluentBitNestFilter", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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