import { IConstruct } from 'constructs';
import { IFluentBitParserPlugin } from '../parsers/parser-plugin-base';
import { ResolvedFluentBitConfiguration } from '../resolved-fluent-bit-configuration';
import { FluentBitFilterPluginBase, FluentBitFilterPluginCommonOptions } from './filter-plugin-base';
/**
 * Options for configuring the Parser Fluent Bit filter plugin.
 *
 * @see [Parser Plugin Documention](https://docs.fluentbit.io/manual/pipeline/filters/parser)
 */
export interface FluentBitParserFilterOptions extends FluentBitFilterPluginCommonOptions {
    /**
       * Specify field name in record to parse.
       */
    readonly keyName: string;
    /**
       * The parsers to use to interpret the field.
       */
    readonly parsers?: IFluentBitParserPlugin[];
    /**
       * Keep original `keyName` field in the parsed result.
       *
       * If `false`, the field will be removed.
       *
       * @default false
       */
    readonly preserveKey?: boolean;
    /**
       * Keep all other original fields in the parsed result.
       *
       * If `false`, all other original fields will be removed.
       *
       * @default false
       */
    readonly reserveData?: boolean;
}
/**
 * A Fluent Bit filter that allows parsing of fields in event records.
 */
export declare class FluentBitParserFilter extends FluentBitFilterPluginBase {
    /**
       * Internal collection of the parsers that should be used to evaluate the
       * filter.
       */
    private readonly _parsers;
    /**
       * Specify field name in record to parse.
       */
    readonly keyName: string;
    /**
        * Keep original `keyName` field in the parsed result.
        *
        * If `false`, the field will be removed.
        *
        * @default false
        */
    readonly preserveKey?: boolean;
    /**
        * Keep all other original fields in the parsed result.
        *
        * If `false`, all other original fields will be removed.
        *
        * @default false
        */
    readonly reserveData?: boolean;
    /**
       * Collection of the parsers that should be used to evaluate the filter.
       */
    get parsers(): IFluentBitParserPlugin[];
    /**
       * Creates a new instance of the FluentBitParserFilter class.
       *
       * @param options The configuration options to use for filter.
       */
    constructor(options: FluentBitParserFilterOptions);
    /**
       * Adds a new parser to apply to matched log entries.
       *
       * @param parser The parser to use for matched log entries.
       * @returns The parser filter that the parser plugin was registered with.
       */
    addParser(parser: IFluentBitParserPlugin): FluentBitParserFilter;
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope: IConstruct): ResolvedFluentBitConfiguration;
}
