"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentBitParserFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const filter_plugin_base_1 = require("./filter-plugin-base");
/**
 * A Fluent Bit filter that allows parsing of fields in event records.
 */
class FluentBitParserFilter extends filter_plugin_base_1.FluentBitFilterPluginBase {
    /**
       * Creates a new instance of the FluentBitParserFilter class.
       *
       * @param options The configuration options to use for filter.
       */
    constructor(options) {
        super('parser', options);
        this._parsers = [];
        this.keyName = options.keyName;
        this.preserveKey = options.preserveKey;
        this.reserveData = options.reserveData;
        options.parsers?.forEach((x) => {
            this.addParser(x);
        });
    }
    /**
       * Collection of the parsers that should be used to evaluate the filter.
       */
    get parsers() {
        return [...this._parsers];
    }
    /**
       * Adds a new parser to apply to matched log entries.
       *
       * @param parser The parser to use for matched log entries.
       * @returns The parser filter that the parser plugin was registered with.
       */
    addParser(parser) {
        this._parsers.push(parser);
        return this;
    }
    /**
       * Builds a configuration for this plugin and returns the details for
       * consumtion by a resource that is configuring logging.
       *
       * @param _scope The construct configuring logging using Fluent Bit.
       * @returns A configuration for the plugin that con be used by the resource
       * configuring logging.
       */
    bind(_scope) {
        if (this._parsers.length === 0) {
            throw new Error([
                'At least on parser must be specified when creating a Fluent',
                'Bit parser filter.',
            ].join(' '));
        }
        return {
            configFile: this.renderConfigFile({
                Key_Name: this.keyName,
                Parser: this._parsers.map((x) => {
                    return x.name;
                }),
                Preserve_Key: this.preserveKey,
                Reserve_Data: this.reserveData,
            }),
            parsers: this.parsers,
        };
    }
}
exports.FluentBitParserFilter = FluentBitParserFilter;
_a = JSII_RTTI_SYMBOL_1;
FluentBitParserFilter[_a] = { fqn: "cdk-extensions.k8s_aws.FluentBitParserFilter", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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